<?php
// ═══════════════════════════════════════════════════════════════
//  SIGEDEC STANDALONE — activate.php
//  Primeira coisa que o utilizador vê se não estiver activado
// ═══════════════════════════════════════════════════════════════
define('DEPTH', 0);
require_once __DIR__ . '/includes/config.php';

// Se já está activado, ir para o login ou setup
if (isActivated()) {
    $sys = json_decode(file_get_contents(SYSTEM_FILE), true);
    header('Location: ' . (empty($sys['installed']) ? 'install.php' : 'index.php'));
    exit;
}

$lang  = getLang();
$error = '';
$info  = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $key = trim($_POST['activation_key'] ?? '');
    if (!$key) {
        $error = $lang==='en' ? 'Please enter the activation key.' : 'Por favor, insira a chave de activação.';
    } else {
        $result = activateKey($key);
        if ($result['ok']) {
            header('Location: install.php');
            exit;
        }
        $error = $result['msg'];
    }
}
?>
<!DOCTYPE html>
<html lang="<?= $lang==='en'?'en':'pt' ?>">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<meta name="robots" content="noindex,nofollow">
<title><?= $lang==='en'?'Activate SIGEDEC':'Activar SIGEDEC' ?></title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link href="https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@0,400;0,600;0,700;1,400&family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="assets/css/style.css">
<style>
.activate-page{min-height:100vh;display:flex;align-items:center;justify-content:center;background:var(--navy);padding:2rem}
.activate-card{background:#fff;border-radius:var(--radius);padding:2.5rem;width:100%;max-width:480px;box-shadow:0 20px 60px rgba(0,0,0,0.4)}
.activate-logo{font-family:'Cormorant Garamond',serif;font-size:2.5rem;font-weight:700;color:var(--gold);letter-spacing:3px;text-align:center;margin-bottom:.25rem}
.activate-cross{text-align:center;font-size:2rem;color:var(--gold);margin-bottom:1rem}
.activate-badge{display:inline-flex;align-items:center;gap:.4rem;background:#fef9ee;border:1px solid #fde68a;color:#78350f;font-size:.75rem;font-weight:600;padding:.3rem .75rem;border-radius:20px;margin-bottom:1.5rem}
.activate-steps{background:#f8fafc;border-radius:var(--radius-sm);padding:1.25rem;margin:1.5rem 0;border:1px solid var(--border)}
.activate-steps h4{font-size:.78rem;font-weight:700;text-transform:uppercase;letter-spacing:.06em;color:var(--text-muted);margin-bottom:.75rem}
.activate-steps ol{padding-left:1.25rem}
.activate-steps li{font-size:.855rem;color:var(--text-sub);line-height:1.7;margin-bottom:.2rem}
.activate-steps li a{color:var(--gold);font-weight:600}
.domain-info{background:#f0fdf4;border:1px solid #bbf7d0;border-radius:var(--radius-sm);padding:.75rem 1rem;font-size:.8rem;color:#14532d;margin-bottom:1.25rem;display:flex;align-items:center;gap:.5rem}
</style>
</head>
<body>
<div class="activate-page">
    <div class="activate-card">
        <div class="activate-cross">✝</div>
        <div class="activate-logo">SIGEDEC</div>
        <div style="text-align:center;color:var(--text-muted);font-size:.8rem;margin-bottom:1.5rem;letter-spacing:1.5px;text-transform:uppercase">
            <?= $lang==='en' ? 'Standalone Edition' : 'Edição Autónoma' ?>
        </div>

        <?php if ($error): ?>
        <div class="alert alert-danger">❌ <?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <div class="activate-steps">
            <h4><?= $lang==='en' ? 'How to get your key' : 'Como obter a sua chave' ?></h4>
            <ol>
                <li>
                    <?= $lang==='en'
                        ? 'Send an email to <a href="mailto:audivido3@gmail.com?subject=SIGEDEC+Standalone+Key">audivido3@gmail.com</a>'
                        : 'Envie um email para <a href="mailto:audivido3@gmail.com?subject=SIGEDEC+Standalone+Key">audivido3@gmail.com</a>' ?>
                </li>
                <li><?= $lang==='en' ? 'Request the Standalone license key ($20 — one-time payment)' : 'Solicite a chave de licença Standalone ($20 — pagamento único)' ?></li>
                <li><?= $lang==='en' ? 'Make payment via the agreed method' : 'Efectue o pagamento pelo método combinado' ?></li>
                <li><?= $lang==='en' ? 'Receive your unique key and enter it below' : 'Receba a sua chave única e insira-a aqui em baixo' ?></li>
            </ol>
        </div>

        <div class="domain-info">
            🔒 <?= $lang==='en' ? 'This key will be permanently linked to:' : 'Esta chave ficará permanentemente ligada a:' ?>
            <strong><?= htmlspecialchars(INSTALL_DOMAIN) ?></strong>
        </div>

        <form method="POST">
            <div class="form-group">
                <label><?= $lang==='en' ? 'Activation Key' : 'Chave de Activação' ?></label>
                <input type="text" name="activation_key" class="form-control"
                    placeholder="standalone-XXXX-XXXX-XXXX-XXXX"
                    style="font-family:monospace;letter-spacing:.05em"
                    autocomplete="off" required>
            </div>
            <button type="submit" class="btn btn-primary btn-full btn-lg">
                <?= $lang==='en' ? '🔑 Activate' : '🔑 Activar' ?>
            </button>
        </form>

        <div style="text-align:center;margin-top:1.5rem">
            <a href="?lang=<?= $lang==='en'?'pt':'en' ?>" style="font-size:.78rem;color:var(--text-muted)">
                <?= $lang==='en' ? '🌐 Português' : '🌐 English' ?>
            </a>
        </div>

        <div style="text-align:center;margin-top:1.25rem;font-size:.72rem;color:var(--text-muted)">
            Powered by <a href="https://sigedec.asaf.fyi" target="_blank" style="color:var(--gold)">sigedec.asaf.fyi</a>
        </div>
    </div>
</div>
</body></html>
