<?php
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user || $user['role'] !== 'admin') { header('Location: /index.php'); exit; }

$churchId = $user['church_id'];
$church   = getChurchInfo($churchId);
$lang     = getLang();

// Handle backup download
if (isset($_GET['download']) && $_GET['download'] === '1') {
    $churchPath = getChurchPath($churchId);
    $zipName    = 'backup_' . preg_replace('/[^a-z0-9]/i', '_', $church['name'] ?? $churchId) . '_' . date('Ymd_His') . '.zip';

    if (!class_exists('ZipArchive')) {
        die($lang === 'en' ? 'ZipArchive not available on this server.' : 'ZipArchive não disponível neste servidor.');
    }

    $tmpZip = sys_get_temp_dir() . '/' . uniqid('sigedec_bk_') . '.zip';
    $zip    = new ZipArchive();
    if ($zip->open($tmpZip, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
        die($lang === 'en' ? 'Could not create ZIP file.' : 'Não foi possível criar o ficheiro ZIP.');
    }

    // Add all files recursively
    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($churchPath, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::LEAVES_ONLY
    );
    foreach ($files as $file) {
        if ($file->isFile()) {
            $filePath   = $file->getRealPath();
            $relativePath = substr($filePath, strlen($churchPath) + 1);
            $zip->addFile($filePath, $relativePath);
        }
    }
    $zip->close();

    // Log backup
    $logFile = $churchPath . '/backup_log.json';
    $log = readJSON($logFile) ?: [];
    $log[] = ['date' => date('Y-m-d H:i:s'), 'user' => $user['email'] ?? ''];
    writeJSON($logFile, $log);

    header('Content-Type: application/zip');
    header('Content-Disposition: attachment; filename="' . $zipName . '"');
    header('Content-Length: ' . filesize($tmpZip));
    header('Cache-Control: no-cache');
    readfile($tmpZip);
    unlink($tmpZip);
    exit;
}

renderHead(($lang === 'en' ? 'Backup' : 'Backup') . ' — ' . $church['name']);
?>
<body>
<?php renderSidebar('admin', $church); ?>
<div class="main-content">
    <div class="topbar">
        <div class="topbar-left">
            <div class="topbar-title">💾 <?= $lang === 'en' ? 'Backup' : 'Backup de Dados' ?></div>
            <div class="topbar-sub"><?= sanitize($church['name']) ?></div>
        </div>
    </div>
    <div class="page-content">
        <?php renderFlash(); ?>

        <div class="card" style="max-width:600px;margin:0 auto">
            <div class="card-header">
                <h3 class="card-title">💾 <?= $lang === 'en' ? 'Download Denomination Backup' : 'Descarregar Backup da Denominação' ?></h3>
            </div>
            <div style="padding:1.5rem">
                <div class="alert alert-info">
                    ℹ️ <?= $lang === 'en'
                        ? 'The backup generates a ZIP file containing all your denomination data: members, leaders, ministries, subdivisions, finances and configurations. Keep this file in a safe place.'
                        : 'O backup gera um ficheiro ZIP com todos os dados da sua denominação: membros, líderes, ministérios, subdivisões, finanças e configurações. Guarde este ficheiro num local seguro.' ?>
                </div>

                <div style="background:var(--bg-card);border:1px solid var(--border);border-radius:8px;padding:1.25rem;margin-bottom:1.5rem">
                    <div style="font-weight:700;margin-bottom:0.5rem">📦 <?= sanitize($church['name']) ?></div>
                    <div class="text-sm text-muted"><?= $lang === 'en' ? 'Generated on:' : 'Gerado em:' ?> <?= date('d/m/Y \à\s H:i') ?></div>
                    <div class="text-sm text-muted"><?= $lang === 'en' ? 'Format: JSON (ZIP archive)' : 'Formato: JSON (arquivo ZIP)' ?></div>
                </div>

                <a href="?download=1" class="btn btn-primary btn-full" style="font-size:1rem;padding:0.85rem">
                    ⬇️ <?= $lang === 'en' ? 'Download Backup ZIP' : 'Descarregar Backup ZIP' ?>
                </a>

                <p style="margin-top:1rem;font-size:0.8rem;color:var(--text-muted);text-align:center">
                    <?= $lang === 'en'
                        ? 'We recommend doing a backup at least once a month and before any major changes.'
                        : 'Recomendamos fazer backup pelo menos uma vez por mês e antes de qualquer alteração significativa.' ?>
                </p>
            </div>
        </div>
    </div>
</div>
<?php renderJS(); ?>
</body>
</html>
