<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user || $user['role'] !== 'admin') { header('Location: /index.php'); exit; }

$churchId    = $user['church_id'];
$church      = getChurchInfo($churchId);
$leadersData = getLeaders($churchId);
$membersData = getMembers($churchId);
$subsData    = getSubdivisions($churchId);
$activeMembers = array_filter($membersData['members'], fn($m) => $m['status'] === 'activo');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'save_leader') {
        $lid      = $_POST['leader_id'] ?: generateId('ldr');
        $mid      = $_POST['leader_member'] ?? '';
        $sub      = $_POST['leader_subdivision'] ?? '';
        $role     = trim($_POST['leader_role'] ?? '');
        $since    = $_POST['leader_since'] ?? date('Y-m-d');
        $fullTime = !empty($_POST['full_time']) ? true : false;
        if (!$mid) { flashMessage('danger','Seleccione um membro.'); header('Location: leaders.php'); exit; }

        $found = false;
        foreach ($leadersData['leaders'] as &$l) {
            if ($l['id'] === $lid) {
                $l['member_id']      = $mid;
                $l['subdivision_id'] = $sub;
                $l['role']           = $role;
                $l['since']          = $since;
                $l['full_time']      = $fullTime;
                $found = true; break;
            }
        }
        if (!$found) {
            $leadersData['leaders'][] = [
                'id'             => $lid,
                'member_id'      => $mid,
                'subdivision_id' => $sub ?: null,
                'role'           => $role,
                'since'          => $since,
                'full_time'      => $fullTime,
                'salary'         => null,   // gerido pela área financeira
                'created_at'     => date('Y-m-d H:i:s')
            ];
        }
        saveLeaders($churchId, $leadersData);
        flashMessage('success','Líder guardado com sucesso.');
        header('Location: leaders.php'); exit;
    }

    if ($action === 'remove_leader') {
        $lid = $_POST['leader_id'] ?? '';
        $leadersData['leaders'] = array_values(array_filter($leadersData['leaders'], fn($l) => $l['id'] !== $lid));
        saveLeaders($churchId, $leadersData);
        flashMessage('success','Líder removido.');
        header('Location: leaders.php'); exit;
    }
}

renderHead('Líderes — ' . $church['name'], $church);
?>
<body>
<?php renderSidebar($user['role'], $church); ?>
<div class="main-content">
    <div class="topbar">
        <div class="topbar-left"><div class="topbar-title">Líderes</div><div class="topbar-sub"><?= sanitize($church['name']) ?></div></div>
        <div class="topbar-actions"><button class="btn btn-primary btn-sm" data-modal="modal-leader">＋ Adicionar Líder</button></div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <?php renderFlash(); ?>
        <div class="card">
            <div class="card-header"><h3 class="card-title">👑 Equipa de Liderança</h3><span class="badge badge-gold"><?= count($leadersData['leaders']) ?></span></div>
            <?php if (empty($leadersData['leaders'])): ?>
            <div class="empty-state"><div class="empty-icon">👑</div><h3>Sem líderes</h3><p>Adicione os líderes e pastores responsáveis pelas subdivisões.</p><button class="btn btn-primary" data-modal="modal-leader">Adicionar Primeiro Líder</button></div>
            <?php else: ?>
            <div class="table-wrap">
                <table><thead><tr><th>Membro</th><th>Cargo / Função</th><th>Dedicação</th><th>Salário</th><th>Subdivisão</th><th>Desde</th><th>Acções</th></tr></thead><tbody>
                <?php foreach ($leadersData['leaders'] as $l):
                    $mname = getMemberName($churchId, $l['member_id']);
                    $initial = strtoupper(substr($mname, 0, 1)); ?>
                <tr>
                    <td><div class="member-info"><div class="member-avatar" style="background:linear-gradient(135deg,#c9a84c,#f5d78e)"><?= $initial ?></div><div style="font-weight:600"><?= sanitize($mname) ?></div></div></td>
                    <td><span class="badge badge-gold">👑 <?= sanitize($l['role'] ?: 'Líder') ?></span></td>
                    <td>
                        <?php if (!empty($l['full_time'])): ?>
                        <span class="badge" style="background:#dcfce7;color:#16a34a">⏱️ Tempo Inteiro</span>
                        <?php else: ?>
                        <span class="badge" style="background:#f1f5f9;color:#64748b">⏳ Parcial</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if (isset($l['salary']) && $l['salary'] !== null): ?>
                        <span class="badge" style="background:#fef9ee;color:#92400e;border:1px solid #fde68a">💰 <?= number_format((float)$l['salary'], 2, ',', '.') ?> MT</span>
                        <?php else: ?>
                        <span class="text-muted" style="font-size:.8rem">Voluntário</span>
                        <?php endif; ?>
                    </td>
                    <td class="text-sm text-muted"><?= sanitize(getSubdivisionName($churchId, $l['subdivision_id'] ?? null)) ?></td>
                    <td class="text-sm text-muted"><?= $l['since'] ? date('d/m/Y', strtotime($l['since'])) : '—' ?></td>
                    <td>
                        <form method="POST" onsubmit="return confirm('Remover este líder?')" style="display:inline">
                            <input type="hidden" name="action" value="remove_leader">
                            <input type="hidden" name="leader_id" value="<?= $l['id'] ?>">
                            <button type="submit" class="btn btn-danger btn-sm">🗑️</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="modal-overlay" id="modal-leader">
    <div class="modal">
        <div class="modal-header"><h3 class="modal-title">Adicionar Líder</h3><button class="modal-close">✕</button></div>
        <form method="POST">
            <input type="hidden" name="action" value="save_leader">
            <input type="hidden" name="leader_id" value="">
            <div class="modal-body">
                <div class="form-group">
                    <label>Membro <span style="color:var(--danger)">*</span></label>
                    <select name="leader_member" class="form-control" required>
                        <option value="">— Seleccionar Membro —</option>
                        <?php foreach ($activeMembers as $m): ?>
                        <option value="<?= $m['id'] ?>"><?= sanitize($m['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Cargo / Função</label>
                        <input type="text" name="leader_role" class="form-control" placeholder="ex: Pastor, Responsável, Presidente...">
                    </div>
                    <div class="form-group">
                        <label>Data de Início</label>
                        <input type="date" name="leader_since" class="form-control" value="<?= date('Y-m-d') ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label>Dedicação ao Ministério</label>
                    <div style="display:flex;gap:1rem;margin-top:.4rem">
                        <label style="display:flex;align-items:center;gap:.5rem;cursor:pointer;font-weight:400">
                            <input type="radio" name="full_time" value="1" style="accent-color:var(--gold)">
                            <span>⏱️ <strong>Tempo Inteiro</strong> — não exerce outra função fora da Igreja</span>
                        </label>
                        <label style="display:flex;align-items:center;gap:.5rem;cursor:pointer;font-weight:400">
                            <input type="radio" name="full_time" value="" checked style="accent-color:var(--gold)">
                            <span>⏳ <strong>Tempo Parcial</strong> — exerce outra actividade profissional</span>
                        </label>
                    </div>
                </div>
                <div class="form-group">
                    <label>Subdivisão de Liderança</label>
                    <select name="leader_subdivision" class="form-control">
                        <option value="">— Geral (toda a igreja) —</option>
                        <?php foreach ($subsData['subdivisions'] as $s): ?>
                        <option value="<?= $s['id'] ?>"><?= sanitize($s['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-outline modal-close">Cancelar</button><button type="submit" class="btn btn-primary">Adicionar Líder</button></div>
        </form>
    </div>
</div>

<?php renderJS(); ?></body></html>
