<?php
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user) { header('Location: /index.php'); exit; }
if (!in_array($user['role'], ['admin', 'local_user'])) { header('Location: /index.php'); exit; }

$churchId = $user['church_id'];
$church = getChurchInfo($churchId);
$membersData = getMembers($churchId);
$blacklistData = getBlacklist($churchId);
$subsData = getSubdivisions($churchId);

$filterStatus = $_GET['status'] ?? 'all';
$filterSub = $_GET['sub'] ?? 'all';
$showBlacklist = isset($_GET['filter']) && $_GET['filter'] === 'blacklist';
$editId = $_GET['edit'] ?? null;
$editMember = $editId ? getMemberById($churchId, $editId) : null;

// ─── HANDLE POSTS ──────────────────────────────────────────

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'save_member') {
        $memberId = $_POST['member_id'] ?? generateId('mem');
        $isNew = !getMemberById($churchId, $memberId);
        $existingMember = $isNew ? [] : (getMemberById($churchId, $memberId) ?: []);

        $member = [
            'id' => $memberId,
            'name' => trim($_POST['name'] ?? ''),
            'subdivision_id' => $_POST['subdivision_id'] ?? null,
            'birth_date' => $_POST['birth_date'] ?? '',
            'baptism_date' => $_POST['baptism_date'] ?? '',
            'marital_status' => $_POST['marital_status'] ?? 'solteiro',
            'status' => $_POST['status'] ?? 'activo',
            'locality' => trim($_POST['locality'] ?? ''),
            'admin_post' => trim($_POST['admin_post'] ?? ''),
            'district' => trim($_POST['district'] ?? ''),
            'province' => trim($_POST['province'] ?? ''),
            'country' => trim($_POST['country'] ?? 'Moçambique'),
            'notes' => trim($_POST['notes'] ?? ''),
            'dating_with' => trim($_POST['dating_with'] ?? ''),
            'dating_announced' => isset($_POST['dating_announced']) ? $_POST['dating_announced'] : '',
            'wedding_date' => $_POST['wedding_date'] ?? '',
            'spouse_id' => $_POST['spouse_id'] ?? null,
            'cut_history' => json_decode($_POST['cut_history_json'] ?? '[]', true) ?: [],
            'status_reason' => trim($_POST['status_reason'] ?? ''),
            'tithe_status' => $existingMember['tithe_status'] ?? '',
            'created_at' => $isNew ? date('Y-m-d H:i:s') : ($existingMember['created_at'] ?? date('Y-m-d H:i:s')),
        ];

        // If status is cortado, log it
        if ($member['status'] === 'cortado' && !empty($member['status_reason'])) {
            if (!empty($existingMember) && $existingMember['status'] !== 'cortado') {
                $member['cut_history'][] = [
                    'date' => date('Y-m-d'),
                    'reason' => $member['status_reason'],
                    'type' => 'cortado'
                ];
            }
        }
        if ($member['status'] === 'activo') {
            if (!empty($existingMember) && $existingMember['status'] === 'cortado') {
                $member['cut_history'][] = [
                    'date' => date('Y-m-d'),
                    'reason' => 'Devolvido',
                    'type' => 'devolvido'
                ];
            }
        }

        // Preserve + update portal credentials
        $member['portal_email']    = $existingMember['portal_email'] ?? '';
        $member['portal_password'] = $existingMember['portal_password'] ?? '';
        $portalEmail = strtolower(trim($_POST['portal_email'] ?? ''));
        $portalPass  = trim($_POST['portal_password'] ?? '');
        if ($portalEmail) $member['portal_email'] = $portalEmail;
        if ($portalPass)  $member['portal_password'] = password_hash($portalPass, PASSWORD_DEFAULT);

        saveMember($churchId, $member);
        flashMessage('success', $isNew ? 'Membro registado com sucesso.' : 'Dados do membro actualizados.');
        header('Location: members.php');
        exit;
    }

    if ($action === 'blacklist') {
        $mid = $_POST['member_id'] ?? '';
        $reason = trim($_POST['reason'] ?? '');
        $circumstances = trim($_POST['circumstances'] ?? '');
        $m = getMemberById($churchId, $mid);
        if ($m) {
            $m['blacklisted_at'] = date('Y-m-d H:i:s');
            $m['blacklist_reason'] = $reason;
            $m['blacklist_circumstances'] = $circumstances;
            $blacklistData['members'][] = $m;
            writeJSON(getChurchPath($churchId) . '/blacklist.json', $blacklistData);

            // Remove from main list
            $membersData['members'] = array_values(array_filter($membersData['members'], fn($x) => $x['id'] !== $mid));
            writeJSON(getChurchPath($churchId) . '/members.json', $membersData);
            flashMessage('success', 'Membro movido para a lista negra.');
        }
        header('Location: members.php');
        exit;
    }

    if ($action === 'restore_member') {
        $mid = $_POST['member_id'] ?? '';
        foreach ($blacklistData['members'] as $m) {
            if ($m['id'] === $mid) {
                unset($m['blacklisted_at'], $m['blacklist_reason'], $m['blacklist_circumstances']);
                $m['status'] = 'activo';
                $membersData['members'][] = $m;
                writeJSON(getChurchPath($churchId) . '/members.json', $membersData);
                break;
            }
        }
        $blacklistData['members'] = array_values(array_filter($blacklistData['members'], fn($m) => $m['id'] !== $mid));
        writeJSON(getChurchPath($churchId) . '/blacklist.json', $blacklistData);
        flashMessage('success', 'Membro restaurado com sucesso.');
        header('Location: members.php');
        exit;
    }
}

// ─── FILTER MEMBERS ────────────────────────────────────────

$members = $membersData['members'];
if ($filterStatus !== 'all') {
    $members = array_filter($members, fn($m) => $m['status'] === $filterStatus);
}
if ($filterSub !== 'all') {
    $members = array_filter($members, fn($m) => ($m['subdivision_id'] ?? '') === $filterSub);
}
$members = array_values($members);

$basePath = $user['role'] === 'admin' ? '' : '../church/';
renderHead('Membros — ' . $church['name']);
?>
<body>
<?php renderSidebar($user['role'], $church); ?>
<div class="main-content">
    <div class="topbar">
        <div class="topbar-left">
            <div class="topbar-title"><?= $showBlacklist ? 'Lista Negra' : 'Membros' ?></div>
            <div class="topbar-sub"><?= sanitize($church['name']) ?></div>
        </div>
        <div class="topbar-actions">
            <?php if (!$showBlacklist): ?>
            <a href="?filter=blacklist" class="btn btn-outline btn-sm">🚫 Lista Negra (<?= count($blacklistData['members']) ?>)</a>
            <button class="btn btn-primary btn-sm" data-modal="modal-add-member">＋ Novo Membro</button>
            <?php else: ?>
            <a href="members.php" class="btn btn-outline btn-sm">← Voltar</a>
            <?php endif; ?>
        </div>
    </div>

    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <?php renderFlash(); ?>

        <?php if ($showBlacklist): ?>
        <!-- BLACKLIST -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">🚫 Lista Negra</h3>
                <span class="badge badge-danger"><?= count($blacklistData['members']) ?></span>
            </div>
            <?php if (empty($blacklistData['members'])): ?>
            <div class="empty-state"><div class="empty-icon">🚫</div><h3>Lista negra vazia</h3><p>Nenhum membro foi expulso ou desvinculado.</p></div>
            <?php else: ?>
            <div class="table-wrap">
                <table>
                    <thead><tr><th>Nome</th><th>Motivo</th><th>Circunstâncias</th><th>Data</th><th>Acções</th></tr></thead>
                    <tbody>
                    <?php foreach ($blacklistData['members'] as $m): ?>
                    <tr>
                        <td><strong><?= sanitize($m['name']) ?></strong></td>
                        <td><?= sanitize($m['blacklist_reason'] ?? '—') ?></td>
                        <td class="text-sm text-muted"><?= sanitize(substr($m['blacklist_circumstances'] ?? '', 0, 80)) ?></td>
                        <td class="text-sm text-muted"><?= $m['blacklisted_at'] ? date('d/m/Y', strtotime($m['blacklisted_at'])) : '—' ?></td>
                        <td>
                            <form method="POST" style="display:inline" onsubmit="return confirm('Restaurar este membro?')">
                                <input type="hidden" name="action" value="restore_member">
                                <input type="hidden" name="member_id" value="<?= $m['id'] ?>">
                                <button type="submit" class="btn btn-success btn-sm">♻️ Restaurar</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
        </div>

        <?php else: ?>
        <!-- MEMBERS LIST -->
        <div style="display:flex;gap:1rem;flex-wrap:wrap;margin-bottom:1.5rem;align-items:center">
            <div class="search-bar" style="flex:1;min-width:200px">
                <span class="search-icon">🔍</span>
                <input type="text" id="memberSearch" class="form-control" placeholder="Pesquisar membro...">
            </div>
            <select id="statusFilter" class="form-control" style="width:auto" onchange="location.href='?status='+this.value+'&sub=<?= $filterSub ?>'">
                <option value="all" <?= $filterStatus==='all'?'selected':'' ?>>Todos os estados</option>
                <option value="activo" <?= $filterStatus==='activo'?'selected':'' ?>>Activos</option>
                <option value="cortado" <?= $filterStatus==='cortado'?'selected':'' ?>>Cortados</option>
                <option value="desvinculado" <?= $filterStatus==='desvinculado'?'selected':'' ?>>Desvinculados</option>
            </select>
            <select id="subFilter" class="form-control" style="width:auto" onchange="location.href='?status=<?= $filterStatus ?>&sub='+this.value">
                <option value="all" <?= $filterSub==='all'?'selected':'' ?>>Todas as subdivisões</option>
                <?php foreach ($subsData['subdivisions'] as $s): ?>
                <option value="<?= $s['id'] ?>" <?= $filterSub===$s['id']?'selected':'' ?>><?= sanitize($s['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Lista de Membros</h3>
                <span class="badge badge-gold"><?= count($members) ?> membros</span>
            </div>
            <?php if (empty($members)): ?>
            <div class="empty-state">
                <div class="empty-icon">🙏</div>
                <h3>Nenhum membro encontrado</h3>
                <p>Clique em "Novo Membro" para registar o primeiro membro.</p>
            </div>
            <?php else: ?>
            <div class="table-wrap">
                <table id="membersTable">
                    <thead>
                        <tr><th>Nome</th><th>Estado</th><th>E. Civil</th><th>Subdivisão</th><th>Baptismo</th><th>Cortado</th><th>Acções</th></tr>
                    </thead>
                    <tbody>
                    <?php foreach ($members as $m):
                        $cutCount = count(array_filter($m['cut_history'] ?? [], fn($h) => $h['type'] === 'cortado'));
                        $sc = ['activo'=>'badge-success','cortado'=>'badge-warning','desvinculado'=>'badge-danger'][$m['status']] ?? 'badge-grey';
                    ?>
                    <tr>
                        <td>
                            <div class="member-info">
                                <div class="member-avatar"><?= strtoupper(substr($m['name'],0,1)) ?></div>
                                <div>
                                    <div style="font-weight:600"><?= sanitize($m['name']) ?></div>
                                    <?php if (!empty($m['dating_with']) && $m['marital_status']==='solteiro'): ?>
                                    <div class="text-xs" style="color:var(--gold)">💑 Em namoro c/ <?= sanitize($m['dating_with']) ?></div>
                                    <?php endif; ?>
                                    <?php if (!empty($m['spouse_id']) && $m['marital_status']==='casado'): ?>
                                    <div class="text-xs text-muted">💍 Casado(a) c/ <?= sanitize(getMemberName($churchId, $m['spouse_id'])) ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td><span class="badge <?= $sc ?>"><span class="badge-dot"></span><?= statusLabel($m['status']) ?></span></td>
                        <td class="text-sm"><?= ucfirst($m['marital_status'] ?? '—') ?></td>
                        <td class="text-sm text-muted"><?= sanitize(getSubdivisionName($churchId, $m['subdivision_id'] ?? '')) ?></td>
                        <td class="text-sm text-muted"><?= $m['baptism_date'] ? date('d/m/Y', strtotime($m['baptism_date'])) : '—' ?></td>
                        <td class="text-center">
                            <?php if ($cutCount > 0): ?>
                            <span class="badge badge-warning"><?= $cutCount ?>×</span>
                            <?php else: echo '—'; endif; ?>
                        </td>
                        <td>
                            <div style="display:flex;gap:0.35rem">
                                <a href="?edit=<?= $m['id'] ?>" class="btn btn-outline btn-sm">✏️</a>
                                <button class="btn btn-danger btn-sm" onclick="openBlacklist('<?= $m['id'] ?>','<?= sanitize($m['name']) ?>')">🚫</button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modal: Add/Edit Member -->
<?php $isEdit = !!$editMember; $m = $editMember ?: []; ?>
<div class="modal-overlay <?= $isEdit ? 'active' : '' ?>" id="modal-add-member" style="max-height:100vh;overflow-y:auto">
    <div class="modal" style="max-width:720px">
        <div class="modal-header">
            <h3 class="modal-title"><?= $isEdit ? 'Editar Membro' : 'Novo Membro' ?></h3>
            <button class="modal-close" onclick="closeModal('modal-add-member');window.history.replaceState({},'',window.location.pathname)">✕</button>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="save_member">
            <input type="hidden" name="member_id" value="<?= $m['id'] ?? '' ?>">
            <input type="hidden" name="cut_history_json" value="<?= htmlspecialchars(json_encode($m['cut_history'] ?? [])) ?>">
            <div class="modal-body">
                <div class="tabs">
                    <button type="button" class="tab-btn active" data-tab="info">Dados Pessoais</button>
                    <button type="button" class="tab-btn" data-tab="church">Dados Eclesiásticos</button>
                    <button type="button" class="tab-btn" data-tab="marital">Estado Civil</button>
                    <?php if ($isEdit): ?>
                    <button type="button" class="tab-btn" data-tab="history">Histórico</button>
                    <button type="button" class="tab-btn" data-tab="portal">🔐 Portal</button>
                    <?php endif; ?>
                </div>

                <div id="tab-info" class="tab-content active">
                    <div class="form-group">
                        <label>Nome Completo <span style="color:var(--danger)">*</span></label>
                        <input type="text" name="name" class="form-control" required value="<?= sanitize($m['name'] ?? '') ?>">
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Data de Nascimento</label>
                            <input type="date" name="birth_date" class="form-control" value="<?= $m['birth_date'] ?? '' ?>">
                        </div>
                        <div class="form-group">
                            <label>Naturalidade (Localidade)</label>
                            <input type="text" name="locality" class="form-control" placeholder="Localidade" value="<?= sanitize($m['locality'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Posto Administrativo</label>
                            <input type="text" name="admin_post" class="form-control" value="<?= sanitize($m['admin_post'] ?? '') ?>">
                        </div>
                        <div class="form-group">
                            <label>Distrito</label>
                            <input type="text" name="district" class="form-control" value="<?= sanitize($m['district'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Província</label>
                            <input type="text" name="province" class="form-control" value="<?= sanitize($m['province'] ?? '') ?>">
                        </div>
                        <div class="form-group">
                            <label>País</label>
                            <input type="text" name="country" class="form-control" value="<?= sanitize($m['country'] ?? 'Moçambique') ?>">
                        </div>
                    </div>
                </div>

                <div id="tab-church" class="tab-content">
                    <div class="form-row">
                        <div class="form-group">
                            <label>Data de Baptismo</label>
                            <input type="date" name="baptism_date" class="form-control" value="<?= $m['baptism_date'] ?? '' ?>">
                        </div>
                        <div class="form-group">
                            <label>Subdivisão</label>
                            <select name="subdivision_id" class="form-control">
                                <option value="">— Sem subdivisão —</option>
                                <?php foreach ($subsData['subdivisions'] as $s): ?>
                                <option value="<?= $s['id'] ?>" <?= ($m['subdivision_id'] ?? '')===$s['id']?'selected':'' ?>><?= sanitize($s['name']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Estado de Membresia</label>
                            <select name="status" class="form-control" id="statusSelect">
                                <option value="activo" <?= ($m['status']??'')==='activo'?'selected':'' ?>>Activo</option>
                                <option value="cortado" <?= ($m['status']??'')==='cortado'?'selected':'' ?>>Cortado em Comunhão</option>
                                <option value="desvinculado" <?= ($m['status']??'')==='desvinculado'?'selected':'' ?>>Desvinculado</option>
                            </select>
                        </div>
                        <div class="form-group" id="reasonGroup" style="<?= in_array($m['status']??'', ['cortado','desvinculado']) ? '' : 'display:none' ?>">
                            <label>Motivo</label>
                            <input type="text" name="status_reason" class="form-control" placeholder="Descreva o motivo" value="<?= sanitize($m['status_reason'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="form-group" id="circGroup" style="<?= in_array($m['status']??'', ['cortado','desvinculado']) ? '' : 'display:none' ?>">
                        <label>Circunstâncias</label>
                        <textarea name="notes" class="form-control" rows="3" placeholder="Descreva as circunstâncias..."><?= sanitize($m['notes'] ?? '') ?></textarea>
                    </div>
                </div>

                <div id="tab-marital" class="tab-content">
                    <div class="form-group">
                        <label>Estado Civil</label>
                        <select name="marital_status" class="form-control" id="maritalSelect">
                            <option value="solteiro" <?= ($m['marital_status']??'')==='solteiro'?'selected':'' ?>>Solteiro(a)</option>
                            <option value="casado" <?= ($m['marital_status']??'')==='casado'?'selected':'' ?>>Casado(a)</option>
                            <option value="viuvo" <?= ($m['marital_status']??'')==='viuvo'?'selected':'' ?>>Viúvo(a)</option>
                            <option value="divorciado" <?= ($m['marital_status']??'')==='divorciado'?'selected':'' ?>>Divorciado(a)</option>
                        </select>
                    </div>

                    <!-- Solteiro: namoro -->
                    <div id="datingSection" style="<?= ($m['marital_status']??'solteiro')==='solteiro' ? '' : 'display:none' ?>">
                        <div class="form-group">
                            <label>Em namoro com (nome do parceiro)</label>
                            <input type="text" name="dating_with" class="form-control" placeholder="Nome do(a) parceiro(a)" value="<?= sanitize($m['dating_with'] ?? '') ?>">
                        </div>
                        <div class="form-group">
                            <label>Data de Apresentação Pública</label>
                            <input type="date" name="dating_announced" class="form-control" value="<?= $m['dating_announced'] ?? '' ?>">
                        </div>
                    </div>

                    <!-- Casado -->
                    <div id="marriedSection" style="<?= ($m['marital_status']??'')==='casado' ? '' : 'display:none' ?>">
                        <div class="form-row">
                            <div class="form-group">
                                <label>Data de Casamento</label>
                                <input type="date" name="wedding_date" class="form-control" value="<?= $m['wedding_date'] ?? '' ?>">
                            </div>
                            <div class="form-group">
                                <label>Cônjuge (membro do sistema)</label>
                                <select name="spouse_id" class="form-control">
                                    <option value="">— Seleccionar cônjuge —</option>
                                    <?php foreach ($membersData['members'] as $om):
                                        if ($om['id'] === ($m['id'] ?? '')) continue; ?>
                                    <option value="<?= $om['id'] ?>" <?= ($m['spouse_id']??'')===$om['id']?'selected':'' ?>><?= sanitize($om['name']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if ($isEdit): ?>
                <div id="tab-history" class="tab-content">
                    <?php $history = $m['cut_history'] ?? []; ?>
                    <?php if (empty($history)): ?>
                    <div class="empty-state" style="padding:2rem">
                        <p>Nenhum histórico de corte/devolução.</p>
                    </div>
                    <?php else: ?>
                    <p class="text-sm text-muted mb-2">
                        Total de cortes: <strong><?= count(array_filter($history, fn($h) => $h['type']==='cortado')) ?></strong>
                    </p>
                    <table>
                        <thead><tr><th>Data</th><th>Evento</th><th>Descrição</th></tr></thead>
                        <tbody>
                        <?php foreach ($history as $h): ?>
                        <tr>
                            <td class="text-sm"><?= date('d/m/Y', strtotime($h['date'])) ?></td>
                            <td>
                                <span class="badge <?= $h['type']==='cortado' ? 'badge-warning' : 'badge-success' ?>">
                                    <?= $h['type']==='cortado' ? '🔶 Cortado' : '✅ Devolvido' ?>
                                </span>
                            </td>
                            <td class="text-sm text-muted"><?= sanitize($h['reason']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Portal Access Tab -->
                <div id="tab-portal" class="tab-content">
                    <?php $hasPortal = !empty($m['portal_email'] ?? ''); ?>
                    <?php if ($hasPortal): ?>
                    <div class="alert alert-success">
                        ✅ <?= $lang === 'en' ? 'This member already has portal access.' : 'Este membro já tem acesso ao portal.' ?>
                        <br><small>Email: <strong><?= sanitize($m['portal_email']) ?></strong></small>
                    </div>
                    <?php endif; ?>
                    <div class="alert alert-info">
                        🔐 <?= $lang === 'en'
                            ? 'Set the access credentials so this member can log in to their personal portal to view their data, status, and photo.'
                            : 'Defina as credenciais de acesso para que este membro possa entrar no portal pessoal e ver os seus dados, estado e foto.' ?>
                    </div>
                    <div class="form-group">
                        <label><?= $lang === 'en' ? 'Access Email (Portal)' : 'Email de Acesso (Portal)' ?></label>
                        <input type="email" name="portal_email" class="form-control"
                            placeholder="email@exemplo.com"
                            value="<?= sanitize($m['portal_email'] ?? '') ?>">
                        <small class="text-muted"><?= $lang === 'en' ? 'The email the member will use to log in.' : 'O email que o membro usará para entrar.' ?></small>
                    </div>
                    <div class="form-group">
                        <label><?= $lang === 'en' ? 'New Password (Portal)' : 'Nova Senha (Portal)' ?></label>
                        <input type="password" name="portal_password" class="form-control"
                            placeholder="<?= ($m['portal_email'] ?? '') ? ($lang === 'en' ? 'Leave blank to keep current' : 'Deixe em branco para manter') : '••••••••' ?>">
                        <small class="text-muted"><?= $lang === 'en' ? 'Minimum 6 characters.' : 'Mínimo 6 caracteres.' ?></small>
                    </div>
                    <?php if ($hasPortal): ?>
                    <div class="alert alert-warning">
                        ⚠️ <?= $lang === 'en' ? 'The member can only change their own photo and password in the portal. All other data is managed here by the administrator.' : 'O membro apenas pode alterar a própria foto e senha no portal. Todos os outros dados são geridos aqui pelo administrador.' ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline modal-close" onclick="closeModal('modal-add-member');window.history.replaceState({},'',window.location.pathname)">Cancelar</button>
                <button type="submit" class="btn btn-primary"><?= $isEdit ? 'Guardar Alterações' : 'Registar Membro' ?></button>
            </div>
        </form>
    </div>
</div>

<!-- Modal: Blacklist -->
<div class="modal-overlay" id="modal-blacklist">
    <div class="modal">
        <div class="modal-header">
            <h3 class="modal-title">🚫 Expulsar / Desvincular Membro</h3>
            <button class="modal-close">✕</button>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="blacklist">
            <input type="hidden" name="member_id" id="blacklistMemberId">
            <div class="modal-body">
                <p class="text-sm text-muted mb-2">Membro: <strong id="blacklistMemberName"></strong></p>
                <div class="alert alert-warning">⚠️ Esta acção move o membro para a lista negra. Pode restaurá-lo mais tarde se necessário.</div>
                <div class="form-group">
                    <label>Motivo <span style="color:var(--danger)">*</span></label>
                    <input type="text" name="reason" class="form-control" required placeholder="ex: Conduta imoral, abandono, ...">
                </div>
                <div class="form-group">
                    <label>Circunstâncias</label>
                    <textarea name="circumstances" class="form-control" rows="4" placeholder="Descreva detalhadamente as circunstâncias..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline modal-close">Cancelar</button>
                <button type="submit" class="btn btn-danger">Mover para Lista Negra</button>
            </div>
        </form>
    </div>
</div>

<?php renderJS(); ?>
<script>
// Search
filterTable('memberSearch', 'membersTable');

// Marital status toggle
const maritalSelect = document.getElementById('maritalSelect');
if (maritalSelect) {
    maritalSelect.addEventListener('change', () => {
        document.getElementById('datingSection').style.display = maritalSelect.value === 'solteiro' ? '' : 'none';
        document.getElementById('marriedSection').style.display = maritalSelect.value === 'casado' ? '' : 'none';
    });
}

// Status reason toggle
const statusSelect = document.getElementById('statusSelect');
if (statusSelect) {
    statusSelect.addEventListener('change', () => {
        const show = ['cortado','desvinculado'].includes(statusSelect.value);
        document.getElementById('reasonGroup').style.display = show ? '' : 'none';
        document.getElementById('circGroup').style.display = show ? '' : 'none';
    });
}

// Blacklist modal
function openBlacklist(id, name) {
    document.getElementById('blacklistMemberId').value = id;
    document.getElementById('blacklistMemberName').textContent = name;
    openModal('modal-blacklist');
}
</script>
</body>
</html>
