<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user || $user['role'] !== 'church_admin') { header('Location: ../index.php'); exit; }

$churchId = 'main';
$church   = getChurchInfo($churchId);
$branding = getChurchBranding($churchId);
$subsData = getSubdivisions($churchId);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'save_subdivision') {
        $subId = $_POST['sub_id'] ?: generateId('sub');
        $isNew = !getSubdivisionById($churchId, $subId);
        $sub = [
            'id'                 => $subId,
            'name'               => trim($_POST['sub_name'] ?? ''),
            'type'               => trim($_POST['sub_type'] ?? ''),
            'jurisdiction'       => trim($_POST['jurisdiction'] ?? ''),
            'jurisdiction_label' => trim($_POST['jurisdiction_label'] ?? ''),
            'parent_id'          => $_POST['parent_id'] ?: null,
            'created_at'         => $isNew ? date('Y-m-d H:i:s') : ($subsData['subdivisions'][0]['created_at'] ?? date('Y-m-d H:i:s'))
        ];
        if (!$sub['name']) { flashMessage('danger','O nome da subdivisão é obrigatório.'); header('Location: setup.php'); exit; }

        // Guardar/actualizar
        $found = false;
        foreach ($subsData['subdivisions'] as &$s) {
            if ($s['id'] === $subId) { $s = $sub; $found = true; break; }
        }
        if (!$found) $subsData['subdivisions'][] = $sub;
        saveSubdivisions($churchId, $subsData);
        flashMessage('success', $isNew ? 'Subdivisão criada com sucesso.' : 'Subdivisão actualizada.');
        header('Location: setup.php'); exit;
    }

    if ($action === 'delete_subdivision') {
        $subId = $_POST['sub_id'] ?? '';
        $subsData['subdivisions'] = array_values(array_filter($subsData['subdivisions'], fn($s) => $s['id'] !== $subId));
        saveSubdivisions($churchId, $subsData);
        flashMessage('success', 'Subdivisão removida.');
        header('Location: setup.php'); exit;
    }

    if ($action === 'save_terms') {
        $subsData['denomination_terms'] = [
            'level1' => trim($_POST['term1'] ?? ''),
            'level2' => trim($_POST['term2'] ?? ''),
            'level3' => trim($_POST['term3'] ?? ''),
        ];
        saveSubdivisions($churchId, $subsData);
        flashMessage('success', 'Terminologia actualizada.');
        header('Location: setup.php'); exit;
    }
}

$editSubId = $_GET['edit_sub'] ?? null;
$editSub   = $editSubId ? getSubdivisionById($churchId, $editSubId) : null;

$jurisdictions = ['localidade'=>'Localidade','posto'=>'Posto Administrativo','distrito'=>'Distrito','provincia'=>'Província','regiao'=>'Região','nacional'=>'Nacional','internacional'=>'Internacional'];

renderHead('Configuração — ' . $church['name']);
?>
<body>
<?php renderSidebar($user['role']); ?>
<div class="main-content">
    <div class="topbar">
        <div style="display:flex;align-items:center;gap:.85rem"><button class="hamburger" onclick="toggleSidebar()"><span></span><span></span><span></span></button><div><div class="topbar-title">Denominações & Subdivisões</div><div class="topbar-sub"><?= sanitize($church['name']) ?></div></div></div>
        <div class="topbar-actions">
            <button class="btn btn-outline btn-sm" data-modal="modal-branding">🎨 Identidade Visual</button>
            <button class="btn btn-outline btn-sm" data-modal="modal-terms">⚙️ Terminologia</button>
            <button class="btn btn-primary btn-sm" data-modal="modal-sub">＋ Nova Subdivisão</button>
        </div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <?php renderFlash(); ?>

        <!-- Info Terminologia -->
        <?php if (!empty($subsData['denomination_terms']['level1'])): ?>
        <div class="alert alert-info" style="margin-bottom:1.5rem">
            📌 Terminologia configurada:
            <?php $t = $subsData['denomination_terms']; ?>
            <?php if($t['level1']) echo '<strong>'.$t['level1'].'</strong>'; ?>
            <?php if($t['level2']) echo ' → <strong>'.$t['level2'].'</strong>'; ?>
            <?php if($t['level3']) echo ' → <strong>'.$t['level3'].'</strong>'; ?>
        </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Subdivisões / Congregações</h3>
                <span class="badge badge-gold"><?= count($subsData['subdivisions']) ?></span>
            </div>
            <?php if (empty($subsData['subdivisions'])): ?>
            <div class="empty-state">
                <div class="empty-icon">🏘️</div>
                <h3>Sem subdivisões</h3>
                <p>Crie congregações, convenções, sínodos conforme a sua denominação.</p>
                <button class="btn btn-primary" data-modal="modal-sub">＋ Criar Primeira Subdivisão</button>
            </div>
            <?php else: ?>
            <div class="table-wrap">
                <table>
                    <thead><tr><th>Nome</th><th>Tipo</th><th>Jurisdição</th><th>Nível</th><th>Membros</th><th>Acções</th></tr></thead>
                    <tbody>
                    <?php foreach ($subsData['subdivisions'] as $s):
                        $md = getMembers($churchId);
                        $subMemberCount = count(array_filter($md['members'], fn($m) => ($m['subdivision_id']??'') === $s['id']));
                        $parent = $s['parent_id'] ? getSubdivisionById($churchId, $s['parent_id']) : null;
                    ?>
                    <tr>
                        <td><strong><?= sanitize($s['name']) ?></strong></td>
                        <td class="text-sm"><?= sanitize($s['type'] ?? '—') ?></td>
                        <td class="text-sm"><?= sanitize($jurisdictions[$s['jurisdiction'] ?? ''] ?? ($s['jurisdiction'] ?? '—')) ?><?= $s['jurisdiction_label'] ? ' ('.$s['jurisdiction_label'].')' : '' ?></td>
                        <td class="text-sm text-muted"><?= $parent ? '↳ ' . sanitize($parent['name']) : 'Raiz' ?></td>
                        <td><span class="badge badge-gold"><?= $subMemberCount ?></span></td>
                        <td>
                            <div style="display:flex;gap:0.35rem">
                                <a href="?edit_sub=<?= $s['id'] ?>" class="btn btn-outline btn-sm">✏️</a>
                                <form method="POST" onsubmit="return confirm('Remover subdivisão?')" style="display:inline">
                                    <input type="hidden" name="action" value="delete_subdivision">
                                    <input type="hidden" name="sub_id" value="<?= $s['id'] ?>">
                                    <button type="submit" class="btn btn-danger btn-sm">🗑️</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal: Subdivisão -->
<?php $isEditSub = !!$editSub; $s = $editSub ?: []; ?>
<div class="modal-overlay <?= $isEditSub ? 'active' : '' ?>" id="modal-sub">
    <div class="modal" style="max-width:600px">
        <div class="modal-header">
            <h3 class="modal-title"><?= $isEditSub ? 'Editar Subdivisão' : 'Nova Subdivisão' ?></h3>
            <button class="modal-close">✕</button>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="save_subdivision">
            <input type="hidden" name="sub_id" value="<?= $s['id'] ?? '' ?>">
            <div class="modal-body">
                <div class="form-group">
                    <label>Nome da Subdivisão <span style="color:var(--danger)">*</span></label>
                    <input type="text" name="sub_name" class="form-control" required placeholder="ex: Convenção Sul, Igreja Central..." value="<?= sanitize($s['name'] ?? '') ?>">
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Tipo (conforme denominação)</label>
                        <input type="text" name="sub_type" class="form-control" placeholder="ex: Convenção, Congregação, Sínodo..." value="<?= sanitize($s['type'] ?? '') ?>">
                    </div>
                    <div class="form-group">
                        <label>Subdivisão-mãe (opcional)</label>
                        <select name="parent_id" class="form-control">
                            <option value="">— Sem hierarquia superior —</option>
                            <?php foreach ($subsData['subdivisions'] as $ps):
                                if ($ps['id'] === ($s['id'] ?? '')) continue; ?>
                            <option value="<?= $ps['id'] ?>" <?= ($s['parent_id']??'')===$ps['id']?'selected':'' ?>><?= sanitize($ps['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Jurisdição Geográfica</label>
                        <select name="jurisdiction" class="form-control">
                            <?php foreach ($jurisdictions as $k => $v): ?>
                            <option value="<?= $k ?>" <?= ($s['jurisdiction']??'')===$k?'selected':'' ?>><?= $v ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Nome da Jurisdição</label>
                        <input type="text" name="jurisdiction_label" class="form-control" placeholder="ex: Maputo, Sul, Nampula..." value="<?= sanitize($s['jurisdiction_label'] ?? '') ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline modal-close" onclick="window.history.replaceState({},'',window.location.pathname)">Cancelar</button>
                <button type="submit" class="btn btn-primary"><?= $isEditSub ? 'Guardar Alterações' : 'Criar Subdivisão' ?></button>
            </div>
        </form>
    </div>
</div>

<!-- Modal: Terminologia -->
<div class="modal-overlay" id="modal-terms">
    <div class="modal">
        <div class="modal-header"><h3 class="modal-title">⚙️ Terminologia da Denominação</h3><button class="modal-close">✕</button></div>
        <form method="POST">
            <input type="hidden" name="action" value="save_terms">
            <div class="modal-body">
                <p class="text-sm text-muted mb-2">Defina os termos usados na sua denominação para os níveis hierárquicos.</p>
                <?php $t = $subsData['denomination_terms'] ?? []; ?>
                <div class="form-group"><label>Nível 1 (ex: Convenção, Sínodo, Região...)</label><input type="text" name="term1" class="form-control" value="<?= sanitize($t['level1'] ?? '') ?>" placeholder="Convenção"></div>
                <div class="form-group"><label>Nível 2 (ex: Distrito, Zona...)</label><input type="text" name="term2" class="form-control" value="<?= sanitize($t['level2'] ?? '') ?>" placeholder="Distrito"></div>
                <div class="form-group"><label>Nível 3 (ex: Congregação, Igreja Local...)</label><input type="text" name="term3" class="form-control" value="<?= sanitize($t['level3'] ?? '') ?>" placeholder="Congregação"></div>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-outline modal-close">Cancelar</button><button type="submit" class="btn btn-primary">Guardar Terminologia</button></div>
        </form>
    </div>
</div>

<?php renderFooter(); ?>
<?php renderJS(); ?></body></html>
