<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user || $user['role'] !== 'church_admin') { header('Location: ../index.php'); exit; }

$churchId = 'main';
$church   = getChurchInfo($churchId);
$usersData = getChurchUsers($churchId);
$subsData  = getSubdivisions($churchId);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'save_user') {
        $userId = $_POST['user_id'] ?: generateId('usr');
        $isNew  = true;
        $name   = trim($_POST['uname'] ?? '');
        $email  = strtolower(trim($_POST['uemail'] ?? ''));
        $pass   = trim($_POST['upassword'] ?? '');
        $role   = in_array($_POST['urole'], ['local_user','finance_user']) ? $_POST['urole'] : 'local_user';
        $subId  = $_POST['usubdivision'] ?: null;

        if (!$name || !$email) { flashMessage('danger','Nome e email são obrigatórios.'); header('Location: users.php'); exit; }
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) { flashMessage('danger','Email inválido.'); header('Location: users.php'); exit; }

        // Verificar se é edição
        foreach ($usersData['users'] as &$u) {
            if ($u['id'] === $userId) {
                $u['name']           = $name;
                $u['email']          = $email;
                $u['role']           = $role;
                $u['subdivision_id'] = $subId;
                if ($pass) $u['password'] = password_hash($pass, PASSWORD_DEFAULT);
                $isNew = false;
                break;
            }
        }

        if ($isNew) {
            if (!$pass) { flashMessage('danger','Senha obrigatória para novo utilizador.'); header('Location: users.php'); exit; }
            if (strlen($pass) < 6) { flashMessage('danger','Senha deve ter pelo menos 6 caracteres.'); header('Location: users.php'); exit; }
            $usersData['users'][] = [
                'id'             => $userId,
                'name'           => $name,
                'email'          => $email,
                'password'       => password_hash($pass, PASSWORD_DEFAULT),
                'role'           => $role,
                'subdivision_id' => $subId,
                'created_at'     => date('Y-m-d H:i:s')
            ];
        }
        saveChurchUsers($churchId, $usersData);
        flashMessage('success', $isNew ? 'Utilizador criado com sucesso.' : 'Utilizador actualizado.');
        header('Location: users.php'); exit;
    }

    if ($action === 'delete_user') {
        $uid = $_POST['user_id'] ?? '';
        $usersData['users'] = array_values(array_filter($usersData['users'], fn($u) => $u['id'] !== $uid));
        saveChurchUsers($churchId, $usersData);
        flashMessage('success', 'Utilizador removido.');
        header('Location: users.php'); exit;
    }
}

$editUserId = $_GET['edit_user'] ?? null;
$editUser   = null;
if ($editUserId) {
    foreach ($usersData['users'] as $u) {
        if ($u['id'] === $editUserId) { $editUser = $u; break; }
    }
}

renderHead('Utilizadores — ' . $church['name']);
?>
<body>
<?php renderSidebar($user['role']); ?>
<div class="main-content">
    <div class="topbar">
        <div style="display:flex;align-items:center;gap:.85rem"><button class="hamburger" onclick="toggleSidebar()"><span></span><span></span><span></span></button><div><div class="topbar-title">Utilizadores Locais</div><div class="topbar-sub"><?= sanitize($church['name']) ?></div></div></div>
        <div class="topbar-actions"><button class="btn btn-primary btn-sm" data-modal="modal-user">＋ Novo Utilizador</button></div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <?php renderFlash(); ?>
        <div class="alert alert-info">
            ℹ️ Os <strong>Gestores Locais</strong> podem registar e gerir membros da sua subdivisão. Os <strong>Gestores Financeiros</strong> gerem apenas o módulo financeiro.
        </div>
        <div class="card">
            <div class="card-header"><h3 class="card-title">Utilizadores do Sistema</h3><span class="badge badge-gold"><?= count($usersData['users']) ?></span></div>
            <?php if (empty($usersData['users'])): ?>
            <div class="empty-state"><div class="empty-icon">👤</div><h3>Sem utilizadores</h3><p>Crie utilizadores para gerir subdivisões e finanças.</p></div>
            <?php else: ?>
            <div class="table-wrap">
                <table><thead><tr><th>Nome</th><th>Email</th><th>Função</th><th>Subdivisão</th><th>Acções</th></tr></thead><tbody>
                <?php foreach ($usersData['users'] as $u): ?>
                <tr>
                    <td><div class="member-info"><div class="member-avatar"><?= strtoupper(substr($u['name'],0,1)) ?></div><div style="font-weight:600"><?= sanitize($u['name']) ?></div></div></td>
                    <td class="text-sm text-muted"><?= sanitize($u['email']) ?></td>
                    <td>
                        <?php if ($u['role']==='finance_user'): ?>
                        <span class="badge badge-gold">💰 Financeiro</span>
                        <?php else: ?>
                        <span class="badge badge-success">📋 Gestor Local</span>
                        <?php endif; ?>
                    </td>
                    <td class="text-sm text-muted"><?= sanitize(getSubdivisionName($churchId, $u['subdivision_id'] ?? null)) ?></td>
                    <td>
                        <div style="display:flex;gap:0.35rem">
                            <a href="?edit_user=<?= $u['id'] ?>" class="btn btn-outline btn-sm">✏️</a>
                            <form method="POST" onsubmit="return confirm('Remover utilizador?')" style="display:inline">
                                <input type="hidden" name="action" value="delete_user">
                                <input type="hidden" name="user_id" value="<?= $u['id'] ?>">
                                <button type="submit" class="btn btn-danger btn-sm">🗑️</button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal: Utilizador -->
<?php $isEditU = !!$editUser; $eu = $editUser ?: []; ?>
<div class="modal-overlay <?= $isEditU ? 'active' : '' ?>" id="modal-user">
    <div class="modal">
        <div class="modal-header"><h3 class="modal-title"><?= $isEditU ? 'Editar Utilizador' : 'Novo Utilizador' ?></h3><button class="modal-close">✕</button></div>
        <form method="POST">
            <input type="hidden" name="action" value="save_user">
            <input type="hidden" name="user_id" value="<?= $eu['id'] ?? '' ?>">
            <div class="modal-body">
                <div class="form-group"><label>Nome <span style="color:var(--danger)">*</span></label><input type="text" name="uname" class="form-control" required value="<?= sanitize($eu['name'] ?? '') ?>"></div>
                <div class="form-group"><label>Email <span style="color:var(--danger)">*</span></label><input type="email" name="uemail" class="form-control" required value="<?= sanitize($eu['email'] ?? '') ?>"></div>
                <div class="form-group"><label>Senha <?= $isEditU ? '(deixe em branco para manter)' : '<span style="color:var(--danger)">*</span>' ?></label><input type="password" name="upassword" class="form-control" <?= $isEditU ? '' : 'required' ?> placeholder="Mínimo 6 caracteres"></div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Função</label>
                        <select name="urole" class="form-control">
                            <option value="local_user" <?= ($eu['role']??'')==='local_user'?'selected':'' ?>>📋 Gestor Local</option>
                            <option value="finance_user" <?= ($eu['role']??'')==='finance_user'?'selected':'' ?>>💰 Gestor Financeiro</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Subdivisão</label>
                        <select name="usubdivision" class="form-control">
                            <option value="">— Todas —</option>
                            <?php foreach ($subsData['subdivisions'] as $s): ?>
                            <option value="<?= $s['id'] ?>" <?= ($eu['subdivision_id']??'')===$s['id']?'selected':'' ?>><?= sanitize($s['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline modal-close" onclick="window.history.replaceState({},'',window.location.pathname)">Cancelar</button>
                <button type="submit" class="btn btn-primary"><?= $isEditU ? 'Guardar' : 'Criar Utilizador' ?></button>
            </div>
        </form>
    </div>
</div>

<?php renderFooter(); ?>
<?php renderJS(); ?></body></html>
