<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';
$user = currentUser();
if (!$user || $user['role'] !== 'finance_user') { header('Location: ../index.php'); exit; }
$churchId = 'main';
$church   = getChurchInfo($churchId);
$finance  = getFinance($churchId);
$transactions = $finance['transactions'] ?? [];

// Agrupar por mês
$byMonth = [];
foreach ($transactions as $t) {
    $m = substr($t['date'] ?? '', 0, 7);
    if (!isset($byMonth[$m])) $byMonth[$m] = ['entradas'=>0,'saidas'=>0];
    if ($t['type']==='entrada') $byMonth[$m]['entradas'] += (float)$t['amount'];
    else $byMonth[$m]['saidas'] += (float)$t['amount'];
}
krsort($byMonth);

$totalEntradas = calcTotals($transactions, 'entrada');
$totalSaidas   = calcTotals($transactions, 'saida');

renderHead('Relatório Financeiro — ' . $church['name']);
?>
<body>
<?php renderSidebar($user['role']); ?>
<div class="main-content">
    <div class="topbar">
        <div style="display:flex;align-items:center;gap:.85rem"><button class="hamburger" onclick="toggleSidebar()"><span></span><span></span><span></span></button><div><div class="topbar-title">Relatório Financeiro</div><div class="topbar-sub"><?= sanitize($church['name']) ?></div></div></div>
        <div class="topbar-actions"><button onclick="window.print()" class="btn btn-outline btn-sm">🖨️ Imprimir</button></div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <div class="stats-grid" style="grid-template-columns:repeat(3,1fr)">
            <div class="stat-card"><div class="stat-icon" style="background:rgba(34,197,94,0.15);color:#22c55e">💰</div><div class="stat-info"><div class="stat-value" style="color:#22c55e"><?= number_format($totalEntradas,2,',','.') ?> MT</div><div class="stat-label">Total de Entradas</div></div></div>
            <div class="stat-card"><div class="stat-icon" style="background:rgba(239,68,68,0.15);color:#ef4444">💸</div><div class="stat-info"><div class="stat-value" style="color:#ef4444"><?= number_format($totalSaidas,2,',','.') ?> MT</div><div class="stat-label">Total de Saídas</div></div></div>
            <div class="stat-card"><div class="stat-icon" style="background:rgba(168,85,247,0.15);color:#a855f7">📊</div><div class="stat-info"><div class="stat-value" style="color:<?= ($totalEntradas-$totalSaidas)>=0?'#22c55e':'#ef4444' ?>"><?= number_format($totalEntradas-$totalSaidas,2,',','.') ?> MT</div><div class="stat-label">Saldo Global</div></div></div>
        </div>
        <div class="card">
            <div class="card-header"><h3 class="card-title">Resumo por Mês</h3></div>
            <?php if (empty($byMonth)): ?>
            <div class="empty-state"><div class="empty-icon">📊</div><h3>Sem dados</h3></div>
            <?php else: ?>
            <div class="table-wrap">
                <table><thead><tr><th>Mês</th><th>Entradas</th><th>Saídas</th><th>Saldo</th></tr></thead><tbody>
                <?php foreach ($byMonth as $mes => $vals):
                    $saldo = $vals['entradas'] - $vals['saidas']; ?>
                <tr>
                    <td><strong><?= $mes ?></strong></td>
                    <td style="color:#22c55e"><?= number_format($vals['entradas'],2,',','.') ?> MT</td>
                    <td style="color:#ef4444"><?= number_format($vals['saidas'],2,',','.') ?> MT</td>
                    <td style="font-weight:600;color:<?= $saldo>=0?'#22c55e':'#ef4444' ?>"><?= number_format($saldo,2,',','.') ?> MT</td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php renderFooter(); ?>
<?php renderJS(); ?></body></html>
