<?php
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user || !in_array($user['role'], ['admin', 'finance_user'])) {
    header('Location: /index.php'); exit;
}

$churchId    = $user['church_id'];
$church      = getChurchInfo($churchId);
$membersData = getMembers($churchId);
$subsData    = getSubdivisions($churchId);
$lang        = getLang();

// Handle POST: update tithe status for a member
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action   = $_POST['action'] ?? '';
    $memberId = $_POST['member_id'] ?? '';
    $tithe    = $_POST['tithe_status'] ?? '';

    if ($action === 'set_tithe' && $memberId && in_array($tithe, ['regular', 'irregular', 'infiel', ''])) {
        $member = getMemberById($churchId, $memberId);
        if ($member) {
            $member['tithe_status'] = $tithe;
            saveMember($churchId, $member);
            flashMessage('success', $lang === 'en' ? 'Tithe status updated.' : 'Situação do dízimo actualizada.');
        }
    }
    header('Location: tithe.php');
    exit;
}

$filterSub = $_GET['sub'] ?? 'all';
$members = $membersData['members'] ?? [];
if ($filterSub !== 'all') {
    $members = array_filter($members, fn($m) => ($m['subdivision_id'] ?? '') === $filterSub);
}
$members = array_values(array_filter($members, fn($m) => ($m['status'] ?? '') === 'activo'));

renderHead(($lang === 'en' ? 'Tithe/Contribution Status' : 'Situação Dízimo/Contribuições') . ' — ' . $church['name']);
?>
<body>
<?php renderSidebar($user['role'], $church); ?>
<div class="main-content">
    <div class="topbar">
        <div class="topbar-left">
            <div class="topbar-title">🙏 <?= $lang === 'en' ? 'Tithe/Contribution Status' : 'Situação Dízimo/Contribuições' ?></div>
            <div class="topbar-sub"><?= sanitize($church['name']) ?></div>
        </div>
    </div>
    <div class="page-content">
        <?php renderFlash(); ?>

        <div class="alert alert-info">
            ℹ️ <?= $lang === 'en'
                ? 'Set the tithe/contribution status for each active member. This information is visible to the member in their personal portal.'
                : 'Defina a situação do dízimo/contribuições para cada membro activo. Esta informação é visível pelo membro no seu portal pessoal.' ?>
        </div>

        <!-- Filter by subdivision -->
        <div style="margin-bottom:1.5rem;display:flex;gap:1rem;align-items:center;flex-wrap:wrap">
            <div class="search-bar" style="flex:1;min-width:200px">
                <span class="search-icon">🔍</span>
                <input type="text" id="memberSearch" class="form-control" placeholder="<?= $lang === 'en' ? 'Search member...' : 'Pesquisar membro...' ?>">
            </div>
            <select class="form-control" style="width:auto" onchange="location.href='?sub='+this.value">
                <option value="all" <?= $filterSub === 'all' ? 'selected' : '' ?>><?= $lang === 'en' ? 'All subdivisions' : 'Todas as subdivisões' ?></option>
                <?php foreach ($subsData['subdivisions'] as $s): ?>
                <option value="<?= $s['id'] ?>" <?= $filterSub === $s['id'] ? 'selected' : '' ?>><?= sanitize($s['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $lang === 'en' ? 'Active Members' : 'Membros Activos' ?></h3>
                <span class="badge badge-gold"><?= count($members) ?></span>
            </div>
            <?php if (empty($members)): ?>
            <div class="empty-state">
                <div class="empty-icon">🙏</div>
                <h3><?= $lang === 'en' ? 'No members found' : 'Nenhum membro encontrado' ?></h3>
            </div>
            <?php else: ?>
            <div class="table-wrap">
                <table id="membersTable">
                    <thead>
                        <tr>
                            <th><?= $lang === 'en' ? 'Member' : 'Membro' ?></th>
                            <th><?= $lang === 'en' ? 'Subdivision' : 'Subdivisão' ?></th>
                            <th><?= $lang === 'en' ? 'Current Status' : 'Situação Actual' ?></th>
                            <th><?= $lang === 'en' ? 'Update' : 'Actualizar' ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($members as $m): ?>
                    <?php $ts = $m['tithe_status'] ?? ''; ?>
                    <tr>
                        <td>
                            <div class="member-info">
                                <div class="member-avatar"><?= strtoupper(substr($m['name'], 0, 1)) ?></div>
                                <div style="font-weight:600"><?= sanitize($m['name']) ?></div>
                            </div>
                        </td>
                        <td class="text-sm text-muted"><?= sanitize(getSubdivisionName($churchId, $m['subdivision_id'] ?? '')) ?></td>
                        <td>
                            <?php if ($ts): ?>
                            <span class="badge <?= titheBadge($ts) ?>"><?= titheLabel($ts, $lang) ?></span>
                            <?php else: ?>
                            <span class="badge badge-grey"><?= $lang === 'en' ? 'Not set' : 'Não definido' ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <form method="POST" style="display:flex;gap:0.5rem;align-items:center">
                                <input type="hidden" name="action" value="set_tithe">
                                <input type="hidden" name="member_id" value="<?= $m['id'] ?>">
                                <select name="tithe_status" class="form-control form-control-sm" style="width:auto;font-size:0.8rem">
                                    <option value=""><?= $lang === 'en' ? '— Not set —' : '— Não definido —' ?></option>
                                    <option value="regular"   <?= $ts === 'regular'   ? 'selected' : '' ?>><?= $lang === 'en' ? '✅ Regular' : '✅ Regular' ?></option>
                                    <option value="irregular" <?= $ts === 'irregular' ? 'selected' : '' ?>><?= $lang === 'en' ? '⚠️ Irregular' : '⚠️ Irregular' ?></option>
                                    <option value="infiel"    <?= $ts === 'infiel'    ? 'selected' : '' ?>><?= $lang === 'en' ? '❌ Unfaithful' : '❌ Infiel' ?></option>
                                </select>
                                <button type="submit" class="btn btn-primary btn-sm"><?= $lang === 'en' ? 'Save' : 'Guardar' ?></button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php renderJS(); ?>
<script>filterTable('memberSearch', 'membersTable');</script>
</body>
</html>
