<?php
function renderHead($title = 'SIGEDEC', ?array $church = null) {
    $lang = getLang();
    $safeTitle = htmlspecialchars($title, ENT_QUOTES, 'UTF-8');

    // Branding da denominação
    $brandCss = '';
    $faviconHtml = "<link rel='icon' type='image/svg+xml' href='/assets/favicon.svg'><link rel='shortcut icon' href='/assets/favicon.svg'>";
    if ($church) {
        $br = getChurchBranding($church['id'] ?? '');
        if (!empty($br['primary']) && $br['primary'] !== '#0f1729') {
            $p = htmlspecialchars($br['primary']); $a = htmlspecialchars($br['accent']);
            // Gerar variações automáticas a partir da cor primária
            $brandCss = "<style>:root{--navy:{$p};--navy-mid:{$p}dd;--navy-light:{$p}bb;--gold:{$a};--gold-light:{$a}cc;--gold-pale:{$a}22;--primary-dark:{$p};--primary:{$p}ee;}</style>";
        }
        if (!empty($br['logo_b64']) && !empty($br['logo_type'])) {
            $logoDataUrl = 'data:' . $br['logo_type'] . ';base64,' . $br['logo_b64'];
            $faviconHtml = "<link rel='icon' href='" . $logoDataUrl . "'>";
        }
    }

    echo "<!DOCTYPE html>
<html lang='{$lang}'>
<head>
<meta charset='UTF-8'>
<meta name='viewport' content='width=device-width, initial-scale=1.0, viewport-fit=cover'>
<title>{$safeTitle} — SIGEDEC</title>
<meta name='application-name' content='SIGEDEC — Sistema de Gestão Denominacional Eclesiástica'>
<link rel='preconnect' href='https://fonts.googleapis.com'>
<link rel='preconnect' href='https://fonts.gstatic.com' crossorigin>
<link href='https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@0,400;0,600;0,700;1,400&family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap' rel='stylesheet'>
<link rel='stylesheet' href='/assets/css/style.css'>
{$faviconHtml}
{$brandCss}
</head>";
}

function renderSidebar($role, $church = null) {
    $user = currentUser();
    $base = getBaseUrl();
    $initial = strtoupper(substr($user['name'], 0, 1));
    $lang = getLang();

    // ── Bloquear acesso se licença expirada (church_admin) ──────────────
    if ($role === 'church_admin' && $church) {
        $ls = getLicenseStatus($church);
        if ($ls['status'] === 'expired') {
            $currentFile = basename($_SERVER['SCRIPT_FILENAME'] ?? '');
            if (!in_array($currentFile, ['license.php', 'logout.php'])) {
                header('Location: /church/license.php?expired=1');
                exit;
            }
        }
    }

    $roleName = [
        'super_admin'  => ($lang==='en' ? 'General Admin'   : 'Admin Geral'),
        'church_admin' => ($lang==='en' ? 'Church Admin'    : 'Admin da Igreja'),
        'local_user'   => ($lang==='en' ? 'Local Manager'   : 'Gestor Local'),
        'finance_user' => ($lang==='en' ? 'Finance Manager' : 'Gestor Financeiro'),
        'member'       => ($lang==='en' ? 'Member'          : 'Membro')
    ][$role] ?? $role;
    $churchName = $church ? sanitize($church['name']) : 'SIGEDEC';

    // Indicador de licença para church_admin
    $licenseHtml = '';
    if ($church && $role === 'church_admin') {
        $ls = getLicenseStatus($church);
        $lsColor = match($ls['status']) { 'licensed'=>'#22c55e','trial'=>'#c9a84c','expired'=>'#ef4444', default=>'#64748b' };
        $lsLabel = match($ls['status']) {
            'licensed' => ($lang==='en' ? 'Licensed' : 'Licenciada'),
            'trial'    => ($lang==='en' ? "Trial — {$ls['days']}d" : "Trial — {$ls['days']}d"),
            'expired'  => ($lang==='en' ? '⚠️ Expired' : '⚠️ Expirada'),
            default    => '—'
        };
        $licenseHtml = "<div style='background:rgba(0,0,0,0.2);border-radius:6px;padding:0.4rem 0.75rem;margin:0.75rem 1rem 0;display:flex;align-items:center;gap:0.4rem;font-size:0.72rem'>
            <span style='width:7px;height:7px;border-radius:50%;background:{$lsColor};display:inline-block'></span>
            <span style='color:rgba(255,255,255,0.6)'>{$lsLabel}</span>
            " . ($ls['status']==='expired' ? "<a href='{$base}/church/license.php' style='color:#c9a84c;margin-left:auto;font-size:0.7rem'>" . ($lang==='en' ? 'Renew' : 'Renovar') . " →</a>" : "") . "
        </div>";
    }


    // Tagline bilingue
    $tagline = $lang === 'en'
        ? 'DECMASY — Denominational Ecclesiastical Management System'
        : 'SIGEDEC — Sistema de Gestão Denominacional Eclesiástica';

    // Lang switcher
    $otherLang = $lang === 'en' ? 'pt' : 'en';
    $otherLangLabel = $lang === 'en' ? 'Português' : 'English';
    $currentPage = $_SERVER['REQUEST_URI'] ?? '/';
    $sep = strpos($currentPage, '?') === false ? '?' : '&';
    $langUrl = $currentPage . $sep . 'lang=' . $otherLang;

    // Logo ou ícone padrão
    $logoIconHtml = "<div class='sidebar-mini-cross'>✝</div>";
    if ($church && !empty(getChurchBranding($church['id'] ?? '')['logo_b64'])) {
        $br2 = getChurchBranding($church['id'] ?? '');
        $logoUrl2 = 'data:' . $br2['logo_type'] . ';base64,' . $br2['logo_b64'];
        $logoIconHtml = "<img src='{$logoUrl2}' alt='Logo' style='width:36px;height:36px;object-fit:contain;border-radius:6px;flex-shrink:0'>";
    }

    echo "
<aside class='sidebar' id='sidebar'>
    <div class='sidebar-brand'>
        {$logoIconHtml}
        <div>
            <div class='sidebar-logo-text'>SIGEDEC</div>
            <div class='sidebar-church-name'>{$churchName}</div>
        </div>
    </div>
    <div style='padding:.35rem 1rem .5rem;font-size:.62rem;color:rgba(255,255,255,.28);line-height:1.35;letter-spacing:.02em;border-bottom:1px solid rgba(255,255,255,.06);margin-bottom:.25rem'>
        {$tagline}
    </div>
    {$licenseHtml}
    <nav class='sidebar-nav'>";

    if ($role === 'super_admin') {
        echo "
        <span class='nav-section-title'>" . ($lang==='en' ? 'Dashboard' : 'Painel') . "</span>
        <a href='{$base}/admin/' class='nav-item " . isActive('/admin/index') . "'><span class='nav-icon'>🏠</span> " . ($lang==='en' ? 'Dashboard' : 'Painel') . "</a>
        <a href='{$base}/admin/churches.php' class='nav-item " . isActive('/admin/churches') . "'><span class='nav-icon'>🏛️</span> " . ($lang==='en' ? 'Denominations' : 'Denominações') . "</a>
        <span class='nav-section-title'>" . ($lang==='en' ? 'Reports' : 'Relatórios') . "</span>
        <a href='{$base}/admin/reports.php' class='nav-item " . isActive('/admin/reports') . "'><span class='nav-icon'>📊</span> " . ($lang==='en' ? 'Global Reports' : 'Relatórios Globais') . "</a>
        <a href='{$base}/public/' class='nav-item' target='_blank'><span class='nav-icon'>🌐</span> " . ($lang==='en' ? 'Public Page' : 'Página Pública') . "</a>
        <span class='nav-section-title'>" . ($lang==='en' ? 'System' : 'Sistema') . "</span>
        <a href='{$base}/admin/backup.php' class='nav-item " . isActive('/admin/backup') . "'><span class='nav-icon'>💾</span> " . ($lang==='en' ? 'Full Backup' : 'Backup Geral') . "</a>";
    }

    if ($role === 'church_admin') {
        echo "
        <span class='nav-section-title'>" . ($lang==='en' ? 'Dashboard' : 'Painel') . "</span>
        <a href='{$base}/church/' class='nav-item " . isActive('/church/index') . "'><span class='nav-icon'>🏠</span> " . ($lang==='en' ? 'Dashboard' : 'Painel') . "</a>
        <span class='nav-section-title'>" . ($lang==='en' ? 'Configuration' : 'Configuração') . "</span>
        <a href='{$base}/church/setup.php' class='nav-item " . isActive('/church/setup') . "'><span class='nav-icon'>⚙️</span> " . ($lang==='en' ? 'Subdivisions' : 'Subdivisões') . "</a>
        <a href='{$base}/church/users.php' class='nav-item " . isActive('/church/users') . "'><span class='nav-icon'>👥</span> " . ($lang==='en' ? 'Users' : 'Utilizadores') . "</a>
        <a href='{$base}/church/license.php' class='nav-item " . isActive('/church/license') . "'><span class='nav-icon'>🔑</span> " . ($lang==='en' ? 'License' : 'Licença') . "</a>
        <span class='nav-section-title'>" . ($lang==='en' ? 'Management' : 'Gestão') . "</span>
        <a href='{$base}/church/members.php' class='nav-item " . isActive('/church/members') . "'><span class='nav-icon'>🙏</span> " . ($lang==='en' ? 'Members' : 'Membros') . "</a>
        <a href='{$base}/church/ministries.php' class='nav-item " . isActive('/church/ministries') . "'><span class='nav-icon'>✝️</span> " . ($lang==='en' ? 'Ministries' : 'Ministérios') . "</a>
        <a href='{$base}/church/leaders.php' class='nav-item " . isActive('/church/leaders') . "'><span class='nav-icon'>👑</span> " . ($lang==='en' ? 'Leaders' : 'Líderes') . "</a>
        <span class='nav-section-title'>" . ($lang==='en' ? 'Reports' : 'Relatórios') . "</span>
        <a href='{$base}/church/reports.php' class='nav-item " . isActive('/church/reports') . "'><span class='nav-icon'>📊</span> " . ($lang==='en' ? 'Reports' : 'Relatórios') . "</a>
        <span class='nav-section-title'>" . ($lang==='en' ? 'Finance' : 'Financeiro') . "</span>
        <a href='{$base}/finance/' class='nav-item " . isActive('/finance/index') . "'><span class='nav-icon'>💰</span> " . ($lang==='en' ? 'Finance' : 'Financeiro') . "</a>
        <a href='{$base}/public/' class='nav-item' target='_blank'><span class='nav-icon'>🌐</span> " . ($lang==='en' ? 'Public Page' : 'Página Pública') . "</a>
        <span class='nav-section-title'>" . ($lang==='en' ? 'System' : 'Sistema') . "</span>
        <a href='{$base}/church/backup.php' class='nav-item " . isActive('/church/backup') . "'><span class='nav-icon'>💾</span> Backup</a>
        <span class='nav-section-title'>" . ($lang==='en' ? 'Pastoral' : 'Pastoral') . "</span>
        <a href='{$base}/finance/salaries.php' class='nav-item " . isActive('/finance/salaries') . "'><span class='nav-icon'>💰</span> " . ($lang==='en' ? 'Leader Salaries' : 'Salários') . "</a>";
    }

    if ($role === 'local_user') {
        echo "
        <span class='nav-section-title'>" . ($lang==='en' ? 'Dashboard' : 'Painel') . "</span>
        <a href='{$base}/local/' class='nav-item " . isActive('/local/index') . "'><span class='nav-icon'>🏠</span> " . ($lang==='en' ? 'Dashboard' : 'Painel') . "</a>
        <span class='nav-section-title'>" . ($lang==='en' ? 'Members' : 'Membros') . "</span>
        <a href='{$base}/local/members.php' class='nav-item " . isActive('/local/members') . "'><span class='nav-icon'>🙏</span> " . ($lang==='en' ? 'Members' : 'Membros') . "</a>
        <a href='{$base}/local/reports.php' class='nav-item " . isActive('/local/reports') . "'><span class='nav-icon'>📊</span> " . ($lang==='en' ? 'Local Report' : 'Relatório Local') . "</a>";
    }

    if ($role === 'finance_user') {
        echo "
        <span class='nav-section-title'>" . ($lang==='en' ? 'Finance' : 'Financeiro') . "</span>
        <a href='{$base}/finance/' class='nav-item " . isActive('/finance/index') . "'><span class='nav-icon'>🏠</span> " . ($lang==='en' ? 'Dashboard' : 'Painel') . "</a>
        <a href='{$base}/finance/categories.php' class='nav-item " . isActive('/finance/categories') . "'><span class='nav-icon'>🏷️</span> " . ($lang==='en' ? 'Categories' : 'Categorias') . "</a>
        <a href='{$base}/finance/index.php' class='nav-item " . isActive('/finance/index') . "'><span class='nav-icon'>💰</span> " . ($lang==='en' ? 'Movements' : 'Movimentos') . "</a>
        <a href='{$base}/finance/reports.php' class='nav-item " . isActive('/finance/reports') . "'><span class='nav-icon'>📊</span> " . ($lang==='en' ? 'Reports' : 'Relatórios') . "</a>
        <span class='nav-section-title'>" . ($lang==='en' ? 'Members' : 'Membros') . "</span>
        <a href='{$base}/finance/tithe.php' class='nav-item " . isActive('/finance/tithe') . "'><span class='nav-icon'>🙏</span> " . ($lang==='en' ? 'Tithe Status' : 'Situação Dízimo') . "</a>
        <a href='{$base}/finance/salaries.php' class='nav-item " . isActive('/finance/salaries') . "'><span class='nav-icon'>💰</span> " . ($lang==='en' ? 'Leader Salaries' : 'Salários') . "</a>";
    }

    if ($role === 'member') {
        echo "
        <span class='nav-section-title'>" . ($lang==='en' ? 'My Area' : 'A Minha Área') . "</span>
        <a href='{$base}/member/' class='nav-item " . isActive('/member/index') . "'><span class='nav-icon'>🙏</span> " . ($lang==='en' ? 'My Profile' : 'Minha Ficha') . "</a>
        <a href='{$base}/member/photo.php' class='nav-item " . isActive('/member/photo') . "'><span class='nav-icon'>📷</span> " . ($lang==='en' ? 'Change Photo' : 'Alterar Foto') . "</a>
        <a href='{$base}/member/password.php' class='nav-item " . isActive('/member/password') . "'><span class='nav-icon'>🔐</span> " . ($lang==='en' ? 'Change Password' : 'Alterar Senha') . "</a>";
    }

    echo "
    </nav>
    <div class='sidebar-footer'>
        <a href='{$langUrl}' class='sidebar-lang-btn'>🌐 {$otherLangLabel}</a>
        <div class='sidebar-user'>
            <div class='user-avatar'>{$initial}</div>
            <div class='user-info'>
                <div class='user-name'>" . sanitize($user['name']) . "</div>
                <div class='user-role'>{$roleName}</div>
            </div>
            <a href='{$base}/logout.php' title='" . ($lang==='en' ? 'Sign out' : 'Sair') . "' style='color:rgba(255,255,255,0.3);font-size:1.1rem;margin-left:auto;'>⬅️</a>
        </div>
    </div>
</aside>
<div class='sidebar-overlay' id='sidebarOverlay'></div>
<button class='hamburger' id='hamburger' aria-label='Menu'>
    <span></span><span></span><span></span>
</button>";
}

function isActive($path) {
    return (strpos($_SERVER['SCRIPT_NAME'] ?? '', $path) !== false) ? 'active' : '';
}

function renderFlash() {
    $f = getFlash();
    if (!$f) return;
    $type = $f['type'] === 'success' ? 'alert-success' : ($f['type'] === 'danger' ? 'alert-danger' : 'alert-info');
    $icon = $f['type'] === 'success' ? '✅' : ($f['type'] === 'danger' ? '❌' : 'ℹ️');
    echo "<div class='alert {$type}'>{$icon} " . $f['msg'] . "</div>";
}

function renderSuggestionBanner() {
    $lang = getLang();
    $pt = 'A sua denominação tem uma ideia para melhorar o SIGEDEC? Quer sugerir uma nova funcionalidade, remover algo ou reportar um problema?';
    $en = 'Does your denomination have an idea to improve SIGEDEC? Want to suggest a new feature, remove something or report an issue?';
    $cta_pt = 'Envie a sua sugestão →';
    $cta_en = 'Send your suggestion →';
    $msg  = $lang === 'en' ? $en  : $pt;
    $cta  = $lang === 'en' ? $cta_en : $cta_pt;
    $subj = $lang === 'en' ? 'SIGEDEC — Suggestion' : 'SIGEDEC — Sugestão';
    echo "
<div class='suggestion-banner' id='suggestionBanner'>
    <div class='suggestion-inner'>
        <span class='suggestion-icon'>💡</span>
        <p class='suggestion-text'>{$msg}</p>
        <a href='mailto:" . CONTACT_EMAIL . "?subject=" . urlencode($subj) . "' class='suggestion-btn'>{$cta}</a>
        <button class='suggestion-close' onclick=\"this.closest('#suggestionBanner').style.display='none';localStorage.setItem('sigedec_sugg_closed','1')\" title='Fechar'>✕</button>
    </div>
</div>
<script>
if(localStorage.getItem('sigedec_sugg_closed')==='1'){
    var b=document.getElementById('suggestionBanner');
    if(b) b.style.display='none';
}
</script>";
}

function renderJS() {
    $lang = getLang();
    $footerTagline = $lang === 'en'
        ? 'DECMASY &mdash; Denominational Ecclesiastical Management System &nbsp;|&nbsp; v' . SIGEDEC_VERSION
        : 'SIGEDEC &mdash; Sistema de Gestão Denominacional Eclesiástica &nbsp;|&nbsp; v' . SIGEDEC_VERSION;
    echo "
<div style='text-align:center;padding:.6rem 1rem;font-size:.65rem;color:var(--text-muted);border-top:1px solid var(--border);margin-top:2rem;background:var(--card-bg)' class='system-tagline no-print'>
    {$footerTagline}
</div>";
    echo "
<script>
// ── Sidebar / hamburger ──────────────────────────────────────
const hamburger = document.getElementById('hamburger');
const sidebar   = document.getElementById('sidebar');
const overlay   = document.getElementById('sidebarOverlay');
function openSidebar()  { sidebar.classList.add('open');    overlay.classList.add('active');    document.body.style.overflow='hidden'; }
function closeSidebar() { sidebar.classList.remove('open'); overlay.classList.remove('active'); document.body.style.overflow=''; }
if (hamburger) hamburger.addEventListener('click', () => sidebar.classList.contains('open') ? closeSidebar() : openSidebar());
if (overlay)   overlay.addEventListener('click', closeSidebar);
// Fechar sidebar ao navegar (links dentro da sidebar)
document.querySelectorAll('.sidebar .nav-item').forEach(a => {
    a.addEventListener('click', () => { if(window.innerWidth <= 768) closeSidebar(); });
});
document.querySelectorAll('.tab-btn').forEach(btn => {
    btn.addEventListener('click', () => {
        const target = btn.dataset.tab;
        document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
        document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
        btn.classList.add('active');
        const el = document.getElementById('tab-' + target);
        if (el) el.classList.add('active');
    });
});
function openModal(id) { document.getElementById(id)?.classList.add('active'); document.body.style.overflow='hidden'; }
function closeModal(id) { document.getElementById(id)?.classList.remove('active'); document.body.style.overflow=''; }
document.querySelectorAll('.modal-overlay').forEach(m => { m.addEventListener('click', e => { if (e.target===m) closeModal(m.id); }); });
document.querySelectorAll('[data-modal]').forEach(btn => { btn.addEventListener('click', () => openModal(btn.dataset.modal)); });
document.querySelectorAll('.modal-close').forEach(btn => { btn.addEventListener('click', () => { const m=btn.closest('.modal-overlay'); if(m) closeModal(m.id); }); });
function filterTable(inputId, tableId) {
    const input = document.getElementById(inputId);
    const table = document.getElementById(tableId);
    if (!input || !table) return;
    input.addEventListener('input', () => {
        const val = input.value.toLowerCase();
        table.querySelectorAll('tbody tr').forEach(row => { row.style.display = row.textContent.toLowerCase().includes(val) ? '' : 'none'; });
    });
}
setTimeout(() => {
    document.querySelectorAll('.alert').forEach(a => {
        a.style.transition='opacity 0.5s'; a.style.opacity='0';
        setTimeout(()=>a.remove(),500);
    });
}, 5000);
</script>";
}
?>
