<?php
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user || $user['role'] !== 'member') { header('Location: /index.php'); exit; }

$churchId  = $user['church_id'];
$memberId  = $user['member_id'];
$church    = getChurchInfo($churchId);
$lang      = getLang();
$member    = getMemberById($churchId, $memberId);

if (!$member) {
    session_destroy();
    header('Location: /index.php?expired=1');
    exit;
}

$photoUrl  = getMemberPhotoUrl($churchId, $memberId);
$hasPhoto  = ($photoUrl !== null);
$subsData  = getSubdivisions($churchId);

renderHead(($lang === 'en' ? 'My Profile' : 'Minha Ficha') . ' — ' . $church['name']);
?>
<body>
<?php renderSidebar('member', $church); ?>
<div class="main-content">
    <div class="topbar">
        <div class="topbar-left">
            <div class="topbar-title"><?= $lang === 'en' ? 'My Profile' : 'Minha Ficha' ?></div>
            <div class="topbar-sub"><?= sanitize($church['name']) ?></div>
        </div>
        <div class="topbar-actions">
            <a href="photo.php" class="btn btn-outline btn-sm">📷 <?= $lang === 'en' ? 'Photo' : 'Foto' ?></a>
            <a href="password.php" class="btn btn-outline btn-sm">🔐 <?= $lang === 'en' ? 'Password' : 'Senha' ?></a>
        </div>
    </div>
    <div class="page-content">
        <?php renderFlash(); ?>

        <!-- No-photo alert -->
        <?php if (!$hasPhoto): ?>
        <div class="alert alert-warning" style="display:flex;align-items:center;gap:1rem;flex-wrap:wrap">
            <span style="font-size:1.5rem">📷</span>
            <div style="flex:1">
                <strong><?= $lang === 'en' ? 'No profile photo' : 'Sem foto de perfil' ?></strong><br>
                <small><?= $lang === 'en'
                    ? 'You don\'t have a profile photo yet. You can add one now — take a photo with your device or pick one from your gallery (max 2 MB).'
                    : 'Ainda não tem foto de perfil. Pode adicionar agora — tire uma foto com o seu dispositivo ou escolha uma da galeria (máx. 2 MB).' ?></small>
            </div>
            <a href="photo.php" class="btn btn-primary btn-sm">
                <?= $lang === 'en' ? 'Add Photo →' : 'Adicionar Foto →' ?>
            </a>
        </div>
        <?php endif; ?>

        <!-- Member Card -->
        <div class="card" style="max-width:800px;margin:0 auto">
            <!-- Header with photo -->
            <div style="background:linear-gradient(135deg,var(--primary-dark),var(--primary));padding:2rem;display:flex;gap:1.5rem;align-items:center;border-radius:var(--radius) var(--radius) 0 0;flex-wrap:wrap">
                <div style="width:90px;height:90px;border-radius:50%;border:3px solid rgba(255,255,255,0.3);overflow:hidden;flex-shrink:0;background:rgba(255,255,255,0.1);display:flex;align-items:center;justify-content:center">
                    <?php if ($hasPhoto): ?>
                    <img src="<?= $photoUrl ?>" alt="Foto" style="width:100%;height:100%;object-fit:cover">
                    <?php else: ?>
                    <span style="font-size:2.5rem;color:rgba(255,255,255,0.5)"><?= strtoupper(substr($member['name'], 0, 1)) ?></span>
                    <?php endif; ?>
                </div>
                <div>
                    <h2 style="color:white;margin:0;font-size:1.4rem"><?= sanitize($member['name']) ?></h2>
                    <div style="color:rgba(255,255,255,0.7);font-size:0.85rem;margin-top:0.3rem"><?= sanitize($church['name']) ?></div>
                    <?php
                    $status = $member['status'] ?? 'activo';
                    $statusColors = ['activo' => '#22c55e', 'cortado' => '#f59e0b', 'desvinculado' => '#ef4444'];
                    $statusLabels_pt = ['activo' => 'Membro Activo', 'cortado' => 'Cortado em Comunhão', 'desvinculado' => 'Desvinculado'];
                    $statusLabels_en = ['activo' => 'Active Member', 'cortado' => 'Communion Suspended', 'desvinculado' => 'Unlinked'];
                    $sLabel = $lang === 'en' ? ($statusLabels_en[$status] ?? ucfirst($status)) : ($statusLabels_pt[$status] ?? ucfirst($status));
                    $sColor = $statusColors[$status] ?? '#94a3b8';
                    ?>
                    <div style="display:inline-flex;align-items:center;gap:0.4rem;background:rgba(0,0,0,0.25);border-radius:20px;padding:0.25rem 0.75rem;margin-top:0.5rem">
                        <span style="width:8px;height:8px;border-radius:50%;background:<?= $sColor ?>;display:inline-block"></span>
                        <span style="color:rgba(255,255,255,0.9);font-size:0.8rem"><?= $sLabel ?></span>
                    </div>
                    <?php
                    $titheStatus = $member['tithe_status'] ?? '';
                    if ($titheStatus):
                        $titheColors = ['regular' => '#22c55e', 'irregular' => '#f59e0b', 'infiel' => '#ef4444'];
                        $titheLabels_pt = ['regular' => '🎗️ Dízimo Regular', 'irregular' => '⚠️ Dízimo Irregular', 'infiel' => '❌ Infiel no Dízimo'];
                        $titheLabels_en = ['regular' => '🎗️ Regular Tither', 'irregular' => '⚠️ Irregular Tither', 'infiel' => '❌ Unfaithful Tither'];
                        $tLabel = $lang === 'en' ? ($titheLabels_en[$titheStatus] ?? $titheStatus) : ($titheLabels_pt[$titheStatus] ?? $titheStatus);
                        $tColor = $titheColors[$titheStatus] ?? '#94a3b8';
                    ?>
                    <div style="display:inline-flex;align-items:center;gap:0.4rem;background:rgba(0,0,0,0.25);border-radius:20px;padding:0.25rem 0.75rem;margin-top:0.35rem;margin-left:0.5rem">
                        <span style="width:8px;height:8px;border-radius:50%;background:<?= $tColor ?>;display:inline-block"></span>
                        <span style="color:rgba(255,255,255,0.9);font-size:0.8rem"><?= $tLabel ?></span>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Data sections -->
            <div style="padding:1.5rem">

                <!-- Personal Data -->
                <h3 style="font-size:0.9rem;font-weight:700;text-transform:uppercase;letter-spacing:0.05em;color:var(--text-muted);margin-bottom:1rem;display:flex;align-items:center;gap:0.5rem">
                    👤 <?= $lang === 'en' ? 'Personal Data' : 'Dados Pessoais' ?>
                </h3>
                <div style="display:grid;grid-template-columns:repeat(auto-fill,minmax(200px,1fr));gap:1rem;margin-bottom:1.5rem">
                    <?php
                    $fields_pt = [
                        'birth_date'   => ['label' => 'Data de Nascimento',  'value' => $member['birth_date'] ? date('d/m/Y', strtotime($member['birth_date'])) : '—'],
                        'locality'     => ['label' => 'Localidade',          'value' => $member['locality'] ?? '—'],
                        'admin_post'   => ['label' => 'Posto Administrativo','value' => $member['admin_post'] ?? '—'],
                        'district'     => ['label' => 'Distrito',            'value' => $member['district'] ?? '—'],
                        'province'     => ['label' => 'Província',           'value' => $member['province'] ?? '—'],
                        'country'      => ['label' => 'País',                'value' => $member['country'] ?? '—'],
                    ];
                    $fields_en = [
                        'birth_date'   => ['label' => 'Date of Birth',       'value' => $member['birth_date'] ? date('d/m/Y', strtotime($member['birth_date'])) : '—'],
                        'locality'     => ['label' => 'Locality',            'value' => $member['locality'] ?? '—'],
                        'admin_post'   => ['label' => 'Administrative Post', 'value' => $member['admin_post'] ?? '—'],
                        'district'     => ['label' => 'District',            'value' => $member['district'] ?? '—'],
                        'province'     => ['label' => 'Province',            'value' => $member['province'] ?? '—'],
                        'country'      => ['label' => 'Country',             'value' => $member['country'] ?? '—'],
                    ];
                    $fields = $lang === 'en' ? $fields_en : $fields_pt;
                    foreach ($fields as $f):
                    ?>
                    <div style="background:var(--bg-card);border:1px solid var(--border);border-radius:8px;padding:0.75rem">
                        <div style="font-size:0.7rem;text-transform:uppercase;letter-spacing:0.05em;color:var(--text-muted);margin-bottom:0.2rem"><?= $f['label'] ?></div>
                        <div style="font-weight:600;font-size:0.9rem"><?= sanitize($f['value']) ?></div>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Church Data -->
                <h3 style="font-size:0.9rem;font-weight:700;text-transform:uppercase;letter-spacing:0.05em;color:var(--text-muted);margin-bottom:1rem;display:flex;align-items:center;gap:0.5rem">
                    ✝️ <?= $lang === 'en' ? 'Church Data' : 'Dados Eclesiásticos' ?>
                </h3>
                <div style="display:grid;grid-template-columns:repeat(auto-fill,minmax(200px,1fr));gap:1rem;margin-bottom:1.5rem">
                    <?php
                    $subName = getSubdivisionName($churchId, $member['subdivision_id'] ?? '');
                    $church_fields_pt = [
                        'baptism_date' => ['label' => 'Data de Baptismo', 'value' => $member['baptism_date'] ? date('d/m/Y', strtotime($member['baptism_date'])) : '—'],
                        'subdivision'  => ['label' => 'Subdivisão',       'value' => $subName ?: '—'],
                        'marital'      => ['label' => 'Estado Civil',     'value' => maritalLabel($member['marital_status'] ?? '')],
                        'created_at'   => ['label' => 'Registado em',     'value' => $member['created_at'] ? date('d/m/Y', strtotime($member['created_at'])) : '—'],
                    ];
                    $church_fields_en = [
                        'baptism_date' => ['label' => 'Baptism Date',     'value' => $member['baptism_date'] ? date('d/m/Y', strtotime($member['baptism_date'])) : '—'],
                        'subdivision'  => ['label' => 'Subdivision',      'value' => $subName ?: '—'],
                        'marital'      => ['label' => 'Marital Status',   'value' => maritalLabel($member['marital_status'] ?? '')],
                        'created_at'   => ['label' => 'Registered on',    'value' => $member['created_at'] ? date('d/m/Y', strtotime($member['created_at'])) : '—'],
                    ];
                    $cfields = $lang === 'en' ? $church_fields_en : $church_fields_pt;
                    foreach ($cfields as $f):
                    ?>
                    <div style="background:var(--bg-card);border:1px solid var(--border);border-radius:8px;padding:0.75rem">
                        <div style="font-size:0.7rem;text-transform:uppercase;letter-spacing:0.05em;color:var(--text-muted);margin-bottom:0.2rem"><?= $f['label'] ?></div>
                        <div style="font-weight:600;font-size:0.9rem"><?= sanitize($f['value']) ?></div>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Membership & Tithe Status -->
                <h3 style="font-size:0.9rem;font-weight:700;text-transform:uppercase;letter-spacing:0.05em;color:var(--text-muted);margin-bottom:1rem;display:flex;align-items:center;gap:0.5rem">
                    📋 <?= $lang === 'en' ? 'Membership Status' : 'Estado de Membresia' ?>
                </h3>
                <div style="display:flex;gap:1rem;flex-wrap:wrap;margin-bottom:1.5rem">
                    <!-- Status badge -->
                    <div style="flex:1;min-width:180px;background:var(--bg-card);border:1px solid var(--border);border-radius:8px;padding:1rem;display:flex;align-items:center;gap:0.75rem">
                        <span style="font-size:1.5rem"><?= $status === 'activo' ? '✅' : ($status === 'cortado' ? '🔶' : '❌') ?></span>
                        <div>
                            <div style="font-size:0.7rem;text-transform:uppercase;color:var(--text-muted);letter-spacing:0.05em"><?= $lang === 'en' ? 'Membership' : 'Membresia' ?></div>
                            <div style="font-weight:700;font-size:1rem;color:<?= $sColor ?>"><?= $sLabel ?></div>
                        </div>
                    </div>
                    <!-- Tithe status badge -->
                    <div style="flex:1;min-width:180px;background:var(--bg-card);border:1px solid var(--border);border-radius:8px;padding:1rem;display:flex;align-items:center;gap:0.75rem">
                        <span style="font-size:1.5rem">💰</span>
                        <div>
                            <div style="font-size:0.7rem;text-transform:uppercase;color:var(--text-muted);letter-spacing:0.05em"><?= $lang === 'en' ? 'Tithe/Contributions' : 'Dízimo/Contribuições' ?></div>
                            <?php if ($titheStatus): ?>
                            <div style="font-weight:700;font-size:1rem;color:<?= $tColor ?? '#94a3b8' ?>"><?= titheLabel($titheStatus, $lang) ?></div>
                            <?php else: ?>
                            <div style="font-weight:600;font-size:0.9rem;color:var(--text-muted)"><?= $lang === 'en' ? 'Not defined' : 'Não definido' ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Cut history (if any) -->
                <?php $cutHistory = array_filter($member['cut_history'] ?? [], fn($h) => $h['type'] === 'cortado'); ?>
                <?php if (!empty($cutHistory)): ?>
                <h3 style="font-size:0.9rem;font-weight:700;text-transform:uppercase;letter-spacing:0.05em;color:var(--text-muted);margin-bottom:0.75rem;display:flex;align-items:center;gap:0.5rem">
                    🔶 <?= $lang === 'en' ? 'Suspension History' : 'Histórico de Cortes' ?>
                </h3>
                <div style="margin-bottom:1.5rem">
                    <?php foreach (array_values($cutHistory) as $i => $h): ?>
                    <div style="display:flex;gap:0.75rem;align-items:flex-start;padding:0.5rem 0;border-bottom:1px solid var(--border)">
                        <span class="badge badge-warning" style="flex-shrink:0"><?= $i+1 ?>ª</span>
                        <div>
                            <div style="font-weight:600;font-size:0.85rem"><?= date('d/m/Y', strtotime($h['date'])) ?></div>
                            <div style="font-size:0.8rem;color:var(--text-muted)"><?= sanitize($h['reason']) ?></div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <!-- Quick actions -->
                <div style="display:flex;gap:1rem;flex-wrap:wrap;padding-top:1rem;border-top:1px solid var(--border)">
                    <a href="photo.php" class="btn btn-primary">📷 <?= $lang === 'en' ? 'Change Photo' : 'Alterar Foto' ?></a>
                    <a href="password.php" class="btn btn-outline">🔐 <?= $lang === 'en' ? 'Change Password' : 'Alterar Senha' ?></a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php renderJS(); ?>
</body>
</html>
