<?php
// Photo proxy — serves member photos without exposing JSON data
require_once __DIR__ . '/../includes/config.php';

$churchId = preg_replace('/[^a-zA-Z0-9\-]/', '', $_GET['church'] ?? '');
$memberId = preg_replace('/[^a-zA-Z0-9\-]/', '', $_GET['member'] ?? '');

if (!$churchId || !$memberId) {
    http_response_code(404);
    exit;
}

$exts = ['jpg', 'jpeg', 'png', 'webp'];
foreach ($exts as $ext) {
    $path = CHURCHES_DIR . '/' . $churchId . '/photos/' . $memberId . '.' . $ext;
    if (file_exists($path)) {
        $mime = match($ext) {
            'jpg', 'jpeg' => 'image/jpeg',
            'png'         => 'image/png',
            'webp'        => 'image/webp',
            default       => 'image/jpeg'
        };
        header('Content-Type: ' . $mime);
        header('Cache-Control: max-age=3600');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        exit;
    }
}

http_response_code(404);
